/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.agent.runtime;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.confignode.manager.pipe.agent.PipeConfigNodeAgent;
import org.apache.iotdb.confignode.manager.pipe.agent.runtime.PipeConfigRegionListener;
import org.apache.iotdb.confignode.manager.pipe.extractor.ConfigRegionListeningQueue;
import org.apache.iotdb.confignode.manager.pipe.resource.PipeConfigNodeCopiedFileDirStartupCleaner;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfigNodeRuntimeAgent
implements IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfigNodeRuntimeAgent.class);
    private final PipeConfigRegionListener regionListener = new PipeConfigRegionListener();
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public synchronized void start() {
        PipeConfig.getInstance().printAllConfigs();
        PipeConfigNodeCopiedFileDirStartupCleaner.clean();
        PipeConfigNodeAgent.receiver().cleanPipeReceiverDir();
        this.isShutdown.set(false);
        LOGGER.info("PipeRuntimeConfigNodeAgent started");
    }

    public synchronized void stop() {
        if (this.isShutdown.get()) {
            return;
        }
        this.isShutdown.set(true);
        PipeConfigNodeAgent.task().dropAllPipeTasks();
        LOGGER.info("PipeRuntimeConfigNodeAgent stopped");
    }

    public boolean isShutdown() {
        return this.isShutdown.get();
    }

    public ServiceType getID() {
        return ServiceType.PIPE_RUNTIME_CONFIG_NODE_AGENT;
    }

    public ConfigRegionListeningQueue listener() {
        return this.regionListener.listener();
    }

    public void increaseListenerReference(PipeParameters parameters) throws IllegalPathException {
        this.regionListener.increaseReference(parameters);
    }

    public void decreaseListenerReference(PipeParameters parameters) throws IllegalPathException {
        this.regionListener.decreaseReference(parameters);
    }

    public void notifyLeaderReady() {
        this.regionListener.notifyLeaderReady();
    }

    public void notifyLeaderUnavailable() {
        this.regionListener.notifyLeaderUnavailable();
    }

    public boolean isLeaderReady() {
        return this.regionListener.isLeaderReady();
    }

    public void report(EnrichedEvent event, PipeRuntimeException pipeRuntimeException) {
        if (event.getPipeTaskMeta() != null) {
            this.report(event.getPipeTaskMeta(), pipeRuntimeException);
        } else {
            LOGGER.warn("Attempt to report pipe exception to a null PipeTaskMeta.", (Throwable)pipeRuntimeException);
        }
    }

    private void report(PipeTaskMeta pipeTaskMeta, PipeRuntimeException pipeRuntimeException) {
        LOGGER.warn("Report PipeRuntimeException to local PipeTaskMeta({}), exception message: {}", new Object[]{pipeTaskMeta, pipeRuntimeException.getMessage(), pipeRuntimeException});
        pipeTaskMeta.trackExceptionMessage(pipeRuntimeException);
        if (pipeRuntimeException instanceof PipeRuntimeCriticalException) {
            PipeConfigNodeAgent.task().stopAllPipesWithCriticalException();
        }
    }
}

