/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router.priority;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.IPriorityBalancer;
import org.apache.tsfile.utils.Pair;

public class GreedyPriorityBalancer
implements IPriorityBalancer {
    @Override
    public Map<TConsensusGroupId, TRegionReplicaSet> generateOptimalRoutePriority(List<TRegionReplicaSet> replicaSets, Map<TConsensusGroupId, Integer> regionLeaderMap, Map<Integer, Long> dataNodeLoadScoreMap) {
        TreeMap<TConsensusGroupId, TRegionReplicaSet> regionPriorityMap = new TreeMap<TConsensusGroupId, TRegionReplicaSet>();
        replicaSets.forEach(replicaSet -> {
            TRegionReplicaSet sortedReplicaSet = GreedyPriorityBalancer.sortReplicasByLoadScore(replicaSet, dataNodeLoadScoreMap);
            regionPriorityMap.put(sortedReplicaSet.getRegionId(), sortedReplicaSet);
        });
        return regionPriorityMap;
    }

    protected static TRegionReplicaSet sortReplicasByLoadScore(TRegionReplicaSet replicaSet, Map<Integer, Long> dataNodeLoadScoreMap) {
        TRegionReplicaSet sortedReplicaSet = new TRegionReplicaSet();
        sortedReplicaSet.setRegionId(replicaSet.getRegionId());
        Vector<Pair> sortList = new Vector<Pair>();
        replicaSet.getDataNodeLocations().forEach(dataNodeLocation -> sortList.add(new Pair((Object)dataNodeLoadScoreMap.computeIfAbsent(dataNodeLocation.getDataNodeId(), empty -> Long.MAX_VALUE), dataNodeLocation)));
        sortList.sort(Comparator.comparingLong(Pair::getLeft));
        for (Pair entry : sortList) {
            sortedReplicaSet.addToDataNodeLocations((TDataNodeLocation)entry.getRight());
        }
        return sortedReplicaSet;
    }
}

