/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.cq;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class AddCQPlan
extends ConfigPhysicalPlan {
    private TCreateCQReq req;
    private String md5;
    private long firstExecutionTime;

    public AddCQPlan() {
        super(ConfigPhysicalPlanType.ADD_CQ);
    }

    public AddCQPlan(TCreateCQReq req, String md5, long firstExecutionTime) {
        super(ConfigPhysicalPlanType.ADD_CQ);
        Validate.notNull((Object)req);
        Validate.notNull((Object)md5);
        this.req = req;
        this.md5 = md5;
        this.firstExecutionTime = firstExecutionTime;
    }

    public TCreateCQReq getReq() {
        return this.req;
    }

    public String getMd5() {
        return this.md5;
    }

    public long getFirstExecutionTime() {
        return this.firstExecutionTime;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ThriftCommonsSerDeUtils.serializeTCreateCQReq((TCreateCQReq)this.req, (DataOutputStream)stream);
        ReadWriteIOUtils.write((String)this.md5, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.firstExecutionTime, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.req = ThriftCommonsSerDeUtils.deserializeTCreateCQReq((ByteBuffer)buffer);
        this.md5 = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.firstExecutionTime = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AddCQPlan addCQPlan = (AddCQPlan)o;
        return this.firstExecutionTime == addCQPlan.firstExecutionTime && Objects.equals(this.req, addCQPlan.req) && Objects.equals(this.md5, addCQPlan.md5);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.req, this.md5, this.firstExecutionTime);
    }
}

