/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.confignode.client.CnToDnRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.DataNodeAsyncRequestRPCHandler;
import org.apache.iotdb.mpp.rpc.thrift.TRegionLeaderChangeResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferLeaderRPCHandler
extends DataNodeAsyncRequestRPCHandler<TRegionLeaderChangeResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferLeaderRPCHandler.class);

    public TransferLeaderRPCHandler(CnToDnRequestType requestType, int requestId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TRegionLeaderChangeResp> responseMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetDataNode, dataNodeLocationMap, responseMap, countDownLatch);
    }

    public void onComplete(TRegionLeaderChangeResp response) {
        this.responseMap.put(this.requestId, response);
        if (response.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.nodeLocationMap.remove(this.requestId);
            LOGGER.info("Successfully {} on DataNode: {}", this.requestType, (Object)this.formattedTargetLocation);
        } else {
            LOGGER.error("Failed to {} on DataNode: {}, response: {}", new Object[]{this.requestType, this.formattedTargetLocation, response});
        }
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        String errorMsg = "Failed to " + this.requestType + " on DataNode: " + this.formattedTargetLocation + ", exception: " + e.getMessage();
        LOGGER.error(errorMsg);
        this.responseMap.put(this.requestId, new TRegionLeaderChangeResp(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)errorMsg), -1L));
        this.countDownLatch.countDown();
    }
}

