/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.CnToDnRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.DataNodeAsyncRequestRPCHandler;
import org.apache.iotdb.mpp.rpc.thrift.TCountPathsUsingTemplateResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountPathsUsingTemplateRPCHandler
extends DataNodeAsyncRequestRPCHandler<TCountPathsUsingTemplateResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CountPathsUsingTemplateRPCHandler.class);

    public CountPathsUsingTemplateRPCHandler(CnToDnRequestType requestType, int requestId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TCountPathsUsingTemplateResp> responseMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetDataNode, dataNodeLocationMap, responseMap, countDownLatch);
    }

    public void onComplete(TCountPathsUsingTemplateResp response) {
        TSStatus tsStatus = response.getStatus();
        this.responseMap.put(this.requestId, response);
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.nodeLocationMap.remove(this.requestId);
            LOGGER.info("Successfully count paths using template on DataNode: {}", this.targetNode);
        } else if (tsStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            this.nodeLocationMap.remove(this.requestId);
            LOGGER.error("Failed to count paths using template on DataNode {}, {}", this.targetNode, (Object)tsStatus);
        } else {
            LOGGER.error("Failed to count paths using template on DataNode {}, {}", this.targetNode, (Object)tsStatus);
        }
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        String errorMsg = "Count paths using template error on DataNode: {id=" + ((TDataNodeLocation)this.targetNode).getDataNodeId() + ", internalEndPoint=" + ((TDataNodeLocation)this.targetNode).getInternalEndPoint() + "}" + e.getMessage();
        LOGGER.error(errorMsg);
        this.countDownLatch.countDown();
        TCountPathsUsingTemplateResp resp = new TCountPathsUsingTemplateResp();
        resp.setStatus(new TSStatus(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)errorMsg)));
        this.responseMap.put(this.requestId, resp);
    }
}

