/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.header;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.reader.TsFileInput;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ChunkHeader {
    public static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ChunkHeader.class) + RamUsageEstimator.shallowSizeOfInstance(TSDataType.class) + RamUsageEstimator.shallowSizeOfInstance(CompressionType.class) + RamUsageEstimator.shallowSizeOfInstance(TSEncoding.class);
    private byte chunkType;
    private String measurementID;
    private int dataSize;
    private final TSDataType dataType;
    private final CompressionType compressionType;
    private final TSEncoding encodingType;
    private int numOfPages;
    private final int serializedSize;

    public ChunkHeader(String measurementID, int dataSize, TSDataType dataType, CompressionType compressionType, TSEncoding encoding, int numOfPages) {
        this(measurementID, dataSize, dataType, compressionType, encoding, numOfPages, 0);
    }

    public ChunkHeader(String measurementID, int dataSize, TSDataType dataType, CompressionType compressionType, TSEncoding encoding, int numOfPages, int mask) {
        this((byte)((numOfPages <= 1 ? 5 : 1) | (byte)mask), measurementID, dataSize, ChunkHeader.getSerializedSize(measurementID, dataSize), dataType, compressionType, encoding);
        this.numOfPages = numOfPages;
    }

    public ChunkHeader(byte chunkType, String measurementID, int dataSize, TSDataType dataType, CompressionType compressionType, TSEncoding encoding) {
        this(chunkType, measurementID, dataSize, ChunkHeader.getSerializedSize(measurementID, dataSize), dataType, compressionType, encoding);
    }

    public ChunkHeader(byte chunkType, String measurementID, int dataSize, int headerSize, TSDataType dataType, CompressionType compressionType, TSEncoding encoding) {
        this.chunkType = chunkType;
        this.measurementID = measurementID;
        this.dataSize = dataSize;
        this.dataType = dataType;
        this.compressionType = compressionType;
        this.encodingType = encoding;
        this.serializedSize = headerSize;
    }

    public static int getSerializedSize(String measurementID, int dataSize) {
        int measurementIdLength = measurementID == null ? 0 : measurementID.getBytes(TSFileConfig.STRING_CHARSET).length;
        return 1 + ReadWriteForEncodingUtils.varIntSize(measurementIdLength) + measurementIdLength + ReadWriteForEncodingUtils.uVarIntSize(dataSize) + TSDataType.getSerializedSize() + CompressionType.getSerializedSize() + TSEncoding.getSerializedSize();
    }

    public static int getSerializedSize(String measurementID) {
        int measurementIdLength = measurementID.getBytes(TSFileConfig.STRING_CHARSET).length;
        return 1 + ReadWriteForEncodingUtils.varIntSize(measurementIdLength) + measurementIdLength + 4 + 1 + TSDataType.getSerializedSize() + CompressionType.getSerializedSize() + TSEncoding.getSerializedSize();
    }

    public int getSerializedSize() {
        return this.serializedSize;
    }

    public static ChunkHeader deserializeFrom(InputStream inputStream, byte chunkType) throws IOException {
        String measurementID = ReadWriteIOUtils.readVarIntString(inputStream);
        int dataSize = ReadWriteForEncodingUtils.readUnsignedVarInt(inputStream);
        TSDataType dataType = ReadWriteIOUtils.readDataType(inputStream);
        CompressionType type = ReadWriteIOUtils.readCompressionType(inputStream);
        TSEncoding encoding = ReadWriteIOUtils.readEncoding(inputStream);
        return new ChunkHeader(chunkType, measurementID, dataSize, dataType, type, encoding);
    }

    public static ChunkHeader deserializeFrom(TsFileInput input, long offset) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(6);
        input.read(buffer, offset);
        buffer.flip();
        byte chunkType = buffer.get();
        int strLength = ReadWriteForEncodingUtils.readVarInt(buffer);
        int alreadyReadLength = buffer.position();
        int remainingBytes = strLength + 4 + 1 + TSDataType.getSerializedSize() + CompressionType.getSerializedSize() + TSEncoding.getSerializedSize();
        buffer = ByteBuffer.allocate(remainingBytes);
        input.read(buffer, offset + (long)alreadyReadLength);
        buffer.flip();
        String measurementID = ReadWriteIOUtils.readStringWithLength(buffer, strLength);
        int dataSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        TSDataType dataType = ReadWriteIOUtils.readDataType(buffer);
        CompressionType type = ReadWriteIOUtils.readCompressionType(buffer);
        TSEncoding encoding = ReadWriteIOUtils.readEncoding(buffer);
        int chunkHeaderSize = alreadyReadLength + buffer.position();
        return new ChunkHeader(chunkType, measurementID, dataSize, chunkHeaderSize, dataType, type, encoding);
    }

    public static Pair<CompressionType, TSEncoding> deserializeCompressionTypeAndEncoding(InputStream inputStream) throws IOException {
        ReadWriteForEncodingUtils.readUnsignedVarInt(inputStream);
        ReadWriteIOUtils.skip(inputStream, 1L);
        CompressionType type = ReadWriteIOUtils.readCompressionType(inputStream);
        TSEncoding encoding = ReadWriteIOUtils.readEncoding(inputStream);
        return new Pair<CompressionType, TSEncoding>(type, encoding);
    }

    public String getMeasurementID() {
        return this.measurementID;
    }

    public void setMeasurementID(String measurementID) {
        this.measurementID = measurementID;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int length = 0;
        length += ReadWriteIOUtils.write(this.chunkType, outputStream);
        length += ReadWriteIOUtils.writeVar(this.measurementID, outputStream);
        length += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.dataSize, outputStream);
        length += ReadWriteIOUtils.write(this.dataType, outputStream);
        length += ReadWriteIOUtils.write(this.compressionType, outputStream);
        return length += ReadWriteIOUtils.write(this.encodingType, outputStream);
    }

    public int serializeTo(ByteBuffer buffer) {
        int length = 0;
        length += ReadWriteIOUtils.write(this.chunkType, buffer);
        length += ReadWriteIOUtils.writeVar(this.measurementID, buffer);
        length += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.dataSize, buffer);
        length += ReadWriteIOUtils.write(this.dataType, buffer);
        length += ReadWriteIOUtils.write(this.compressionType, buffer);
        return length += ReadWriteIOUtils.write(this.encodingType, buffer);
    }

    public int getNumOfPages() {
        return this.numOfPages;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public TSEncoding getEncodingType() {
        return this.encodingType;
    }

    public String toString() {
        return "CHUNK_HEADER{measurementID='" + this.measurementID + '\'' + ", dataSize=" + this.dataSize + ", dataType=" + this.dataType + ", compressionType=" + (Object)((Object)this.compressionType) + ", encodingType=" + (Object)((Object)this.encodingType) + ", numOfPages=" + this.numOfPages + ", serializedSize=" + this.serializedSize + '}';
    }

    public void mergeChunkHeader(ChunkHeader chunkHeader) {
        this.dataSize += chunkHeader.getDataSize();
        this.numOfPages += chunkHeader.getNumOfPages();
    }

    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }

    public byte getChunkType() {
        return this.chunkType;
    }

    public void setChunkType(byte chunkType) {
        this.chunkType = chunkType;
    }

    public void increasePageNums(int i) {
        this.numOfPages += i;
    }
}

