/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.encoding.decoder.DeltaBinaryDecoder;
import org.apache.tsfile.encoding.decoder.IntRLBEDecoder;
import org.apache.tsfile.encoding.decoder.IntRleDecoder;
import org.apache.tsfile.encoding.decoder.LongRLBEDecoder;
import org.apache.tsfile.encoding.decoder.LongRleDecoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.encoding.TsFileDecodingException;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatDecoder
extends Decoder {
    private static final Logger logger = LoggerFactory.getLogger(FloatDecoder.class);
    private Decoder decoder;
    private double maxPointValue;
    private boolean isMaxPointNumberRead;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FloatDecoder(TSEncoding encodingType, TSDataType dataType) {
        super(encodingType);
        if (encodingType == TSEncoding.RLE) {
            if (dataType == TSDataType.FLOAT) {
                this.decoder = new IntRleDecoder();
                logger.debug("tsfile-encoding FloatDecoder: init decoder using int-rle and float");
            } else {
                if (dataType != TSDataType.DOUBLE) throw new TsFileDecodingException(String.format("data type %s is not supported by FloatDecoder", dataType));
                this.decoder = new LongRleDecoder();
                logger.debug("tsfile-encoding FloatDecoder: init decoder using long-rle and double");
            }
        } else if (encodingType == TSEncoding.TS_2DIFF) {
            if (dataType == TSDataType.FLOAT) {
                this.decoder = new DeltaBinaryDecoder.IntDeltaDecoder();
                logger.debug("tsfile-encoding FloatDecoder: init decoder using int-delta and float");
            } else {
                if (dataType != TSDataType.DOUBLE) throw new TsFileDecodingException(String.format("data type %s is not supported by FloatDecoder", dataType));
                this.decoder = new DeltaBinaryDecoder.LongDeltaDecoder();
                logger.debug("tsfile-encoding FloatDecoder: init decoder using long-delta and double");
            }
        } else {
            if (encodingType != TSEncoding.RLBE) throw new TsFileDecodingException(String.format("%s encoding is not supported by FloatDecoder", new Object[]{encodingType}));
            if (dataType == TSDataType.FLOAT) {
                this.decoder = new IntRLBEDecoder();
                logger.debug("tsfile-encoding FloatDecoder: init decoder using int-rlbe and float");
            } else {
                if (dataType != TSDataType.DOUBLE) throw new TsFileDecodingException(String.format("data type %s is not supported by FloatDecoder", dataType));
                this.decoder = new LongRLBEDecoder();
                logger.debug("tsfile-encoding FloatDecoder: init decoder using long-rlbe and double");
            }
        }
        this.isMaxPointNumberRead = false;
    }

    @Override
    public float readFloat(ByteBuffer buffer) {
        this.readMaxPointValue(buffer);
        int value = this.decoder.readInt(buffer);
        double result = (double)value / this.maxPointValue;
        return (float)result;
    }

    @Override
    public double readDouble(ByteBuffer buffer) {
        this.readMaxPointValue(buffer);
        long value = this.decoder.readLong(buffer);
        return (double)value / this.maxPointValue;
    }

    private void readMaxPointValue(ByteBuffer buffer) {
        if (!this.isMaxPointNumberRead) {
            int maxPointNumber = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
            this.maxPointValue = maxPointNumber <= 0 ? 1.0 : Math.pow(10.0, maxPointNumber);
            this.isMaxPointNumberRead = true;
        }
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) throws IOException {
        if (this.decoder == null) {
            return false;
        }
        return this.decoder.hasNext(buffer);
    }

    @Override
    public Binary readBinary(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBinary is not supported by FloatDecoder");
    }

    @Override
    public boolean readBoolean(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBoolean is not supported by FloatDecoder");
    }

    @Override
    public short readShort(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readShort is not supported by FloatDecoder");
    }

    @Override
    public int readInt(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readInt is not supported by FloatDecoder");
    }

    @Override
    public long readLong(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readLong is not supported by FloatDecoder");
    }

    @Override
    public void reset() {
        this.decoder.reset();
        this.isMaxPointNumberRead = false;
    }
}

