/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.pattern;

import java.util.Objects;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PrefixPipePattern;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipePattern {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePattern.class);
    protected final String pattern;

    protected PipePattern(String pattern) {
        this.pattern = pattern != null ? pattern : this.getDefaultPattern();
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isRoot() {
        return Objects.isNull(this.pattern) || this.pattern.equals(this.getDefaultPattern());
    }

    public static PipePattern parsePipePatternFromSourceParameters(PipeParameters sourceParameters) {
        String path = sourceParameters.getStringByKeys(new String[]{"extractor.path", "source.path"});
        if (path != null) {
            return new IoTDBPipePattern(path);
        }
        String pattern = sourceParameters.getStringByKeys(new String[]{"extractor.pattern", "source.pattern"});
        if (pattern != null) {
            String patternFormat = sourceParameters.getStringByKeys(new String[]{"extractor.pattern.format", "source.pattern.format"});
            if (patternFormat == null) {
                return new PrefixPipePattern(pattern);
            }
            switch (patternFormat.toLowerCase()) {
                case "iotdb": {
                    return new IoTDBPipePattern(pattern);
                }
                case "prefix": {
                    return new PrefixPipePattern(pattern);
                }
            }
            LOGGER.info("Unknown pattern format: {}, use prefix matching format by default.", (Object)patternFormat);
            return new PrefixPipePattern(pattern);
        }
        return new IoTDBPipePattern(null);
    }

    public abstract String getDefaultPattern();

    public abstract boolean isLegal();

    public abstract boolean coversDb(String var1);

    public abstract boolean coversDevice(String var1);

    public abstract boolean mayOverlapWithDevice(String var1);

    public abstract boolean matchesMeasurement(String var1, String var2);

    public String toString() {
        return "{pattern='" + this.pattern + "'}";
    }
}

