/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task.progress;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.iotdb.commons.pipe.agent.task.progress.CommitterKey;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitter;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.metric.PipeEventCommitMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeEventCommitManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeEventCommitManager.class);
    private final Map<CommitterKey, PipeEventCommitter> eventCommitterMap = new ConcurrentHashMap<CommitterKey, PipeEventCommitter>();
    private final Map<CommitterKey, Integer> eventCommitterRestartTimesMap = new ConcurrentHashMap<CommitterKey, Integer>();
    private BiConsumer<String, Boolean> commitRateMarker;

    public void register(String pipeName, long creationTime, int regionId, String pipePluginName) {
        if (pipeName == null || pipePluginName == null) {
            return;
        }
        CommitterKey committerKey = this.generateCommitterKey(pipeName, creationTime, regionId);
        if (this.eventCommitterMap.containsKey(committerKey)) {
            LOGGER.warn("Pipe with same name is already registered on this region, overwriting: {}", (Object)committerKey);
        }
        PipeEventCommitter eventCommitter = new PipeEventCommitter(committerKey);
        this.eventCommitterMap.put(committerKey, eventCommitter);
        PipeEventCommitMetrics.getInstance().register(eventCommitter, committerKey.stringify());
        LOGGER.info("Pipe committer registered for pipe on region: {}", (Object)committerKey);
    }

    public void deregister(String pipeName, long creationTime, int regionId) {
        CommitterKey committerKey = this.generateCommitterKey(pipeName, creationTime, regionId);
        this.eventCommitterMap.remove(committerKey);
        this.eventCommitterRestartTimesMap.compute(PipeEventCommitManager.generateCommitterRestartTimesKey(pipeName, creationTime, regionId), (k, v) -> Objects.nonNull(v) ? v + 1 : 0);
        PipeEventCommitMetrics.getInstance().deregister(committerKey.stringify());
        LOGGER.info("Pipe committer deregistered for pipe on region: {}", (Object)committerKey);
    }

    public void enrichWithCommitterKeyAndCommitId(EnrichedEvent event, long creationTime, int regionId) {
        if (event == null || event.getPipeName() == null || !event.needToCommit()) {
            return;
        }
        CommitterKey committerKey = this.generateCommitterKey(event.getPipeName(), creationTime, regionId);
        PipeEventCommitter committer = this.eventCommitterMap.get(committerKey);
        if (committer == null) {
            return;
        }
        event.setCommitterKeyAndCommitId(committerKey, committer.generateCommitId());
    }

    public void commit(EnrichedEvent event, CommitterKey committerKey) {
        block9: {
            if (event == null || !event.needToCommit() || Objects.isNull(event.getPipeName()) || event.getCreationTime() == 0L) {
                return;
            }
            if (Objects.nonNull(this.commitRateMarker)) {
                try {
                    this.commitRateMarker.accept(event.getPipeNameWithCreationTime(), event.isDataRegionEvent());
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block9;
                    LOGGER.debug("Failed to mark commit rate for pipe task: {}, stack trace: {}", (Object)committerKey, (Object)Thread.currentThread().getStackTrace());
                }
            }
        }
        if (committerKey == null || event.getCommitId() <= -1L) {
            return;
        }
        PipeEventCommitter committer = this.eventCommitterMap.get(committerKey);
        if (committer == null) {
            int currentRestartTimes = this.eventCommitterRestartTimesMap.computeIfAbsent(PipeEventCommitManager.generateCommitterRestartTimesKey(committerKey), k -> 0);
            if (committerKey.getRestartTimes() < currentRestartTimes) {
                LOGGER.warn("stale PipeEventCommitter({}) when commit event: {}, current restart times {}", new Object[]{committerKey, event.coreReportMessage(), currentRestartTimes});
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("missing PipeEventCommitter({}) when commit event: {}, stack trace: {}", new Object[]{committerKey, event.coreReportMessage(), Thread.currentThread().getStackTrace()});
            }
            return;
        }
        committer.commit(event);
    }

    private CommitterKey generateCommitterKey(String pipeName, long creationTime, int regionId) {
        return new CommitterKey(pipeName, creationTime, regionId, this.eventCommitterRestartTimesMap.computeIfAbsent(PipeEventCommitManager.generateCommitterRestartTimesKey(pipeName, creationTime, regionId), k -> 0));
    }

    private static CommitterKey generateCommitterRestartTimesKey(String pipeName, long creationTime, int regionId) {
        return new CommitterKey(pipeName, creationTime, regionId);
    }

    private static CommitterKey generateCommitterRestartTimesKey(CommitterKey committerKey) {
        return new CommitterKey(committerKey.getPipeName(), committerKey.getCreationTime(), committerKey.getRegionId());
    }

    public void setCommitRateMarker(BiConsumer<String, Boolean> commitRateMarker) {
        this.commitRateMarker = commitRateMarker;
    }

    public long getGivenConsensusPipeCommitId(String consensusPipeName, long creationTime, int consensusGroupId) {
        CommitterKey committerKey = this.generateCommitterKey(consensusPipeName, creationTime, consensusGroupId);
        PipeEventCommitter committer = this.eventCommitterMap.get(committerKey);
        if (committer == null) {
            return 0L;
        }
        return committer.getCurrentCommitId();
    }

    private PipeEventCommitManager() {
    }

    public static PipeEventCommitManager getInstance() {
        return PipeEventCommitManagerHolder.INSTANCE;
    }

    private static class PipeEventCommitManagerHolder {
        private static final PipeEventCommitManager INSTANCE = new PipeEventCommitManager();

        private PipeEventCommitManagerHolder() {
        }
    }
}

