/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus;

import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;

public abstract class ConsensusGroupId {
    protected int id;

    public int getId() {
        return this.id;
    }

    public abstract TConsensusGroupType getType();

    public TConsensusGroupId convertToTConsensusGroupId() {
        return new TConsensusGroupId(this.getType(), this.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsensusGroupId that = (ConsensusGroupId)o;
        return this.getId() == that.getId() && this.getType() == that.getType();
    }

    public String toString() {
        return String.format("%s[%d]", this.getType(), this.getId());
    }

    public static class Factory {
        private Factory() {
        }

        public static ConsensusGroupId create(int type, int id) {
            ConsensusGroupId groupId;
            if (type == TConsensusGroupType.DataRegion.getValue()) {
                groupId = new DataRegionId(id);
            } else if (type == TConsensusGroupType.SchemaRegion.getValue()) {
                groupId = new SchemaRegionId(id);
            } else if (type == TConsensusGroupType.ConfigRegion.getValue()) {
                groupId = new ConfigRegionId(id);
            } else {
                throw new IllegalArgumentException("Unrecognized TConsensusGroupType: " + type + " with id = " + id);
            }
            return groupId;
        }

        public static ConsensusGroupId createFromString(String groupIdString) {
            ConsensusGroupId groupId;
            if (groupIdString.startsWith(TConsensusGroupType.DataRegion.name())) {
                groupId = new DataRegionId(Integer.parseInt(groupIdString.substring(TConsensusGroupType.DataRegion.name().length() + 1, groupIdString.length() - 1)));
            } else if (groupIdString.startsWith(TConsensusGroupType.SchemaRegion.name())) {
                groupId = new SchemaRegionId(Integer.parseInt(groupIdString.substring(TConsensusGroupType.SchemaRegion.name().length() + 1, groupIdString.length() - 1)));
            } else if (groupIdString.startsWith(TConsensusGroupType.ConfigRegion.name())) {
                groupId = new ConfigRegionId(Integer.parseInt(groupIdString.substring(TConsensusGroupType.ConfigRegion.name().length() + 1, groupIdString.length() - 1)));
            } else {
                throw new IllegalArgumentException("Unrecognized ConsensusGroupId: " + groupIdString);
            }
            return groupId;
        }

        public static ConsensusGroupId createFromTConsensusGroupId(TConsensusGroupId tConsensusGroupId) {
            return Factory.create(tConsensusGroupId.getType().getValue(), tConsensusGroupId.getId());
        }
    }
}

