/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.conf;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.ConfigurationFileUtils;
import org.apache.iotdb.commons.enums.HandleSystemErrorStrategy;
import org.apache.iotdb.commons.enums.PipeRemainingTimeRateAverageTime;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.confignode.rpc.thrift.TGlobalConfig;

public class CommonDescriptor {
    private final CommonConfig config = new CommonConfig();

    private CommonDescriptor() {
    }

    public static CommonDescriptor getInstance() {
        return CommonDescriptorHolder.INSTANCE;
    }

    public CommonConfig getConfig() {
        return this.config;
    }

    public String getConfDir() {
        String confString = System.getProperty("IOTDB_CONF", null);
        if (confString == null && (confString = System.getProperty("IOTDB_HOME", null)) != null) {
            confString = confString + File.separatorChar + "conf";
        }
        return confString;
    }

    public void initCommonConfigDir(String systemDir) {
        this.config.setUserFolder(systemDir + File.separator + "users");
        this.config.setRoleFolder(systemDir + File.separator + "roles");
        this.config.setProcedureWalFolder(systemDir + File.separator + "procedure");
    }

    public void loadCommonProps(Properties properties) throws IOException {
        this.config.setAuthorizerProvider(properties.getProperty("authorizer_provider_class", this.config.getAuthorizerProvider()).trim());
        this.config.setOpenIdProviderUrl(properties.getProperty("openID_url", this.config.getOpenIdProviderUrl()).trim());
        this.config.setEncryptDecryptProvider(properties.getProperty("iotdb_server_encrypt_decrypt_provider", this.config.getEncryptDecryptProvider()).trim());
        this.config.setEncryptDecryptProviderParameter(properties.getProperty("iotdb_server_encrypt_decrypt_provider_parameter", this.config.getEncryptDecryptProviderParameter()));
        CharSequence[] tierTTLStr = new String[this.config.getTierTTLInMs().length];
        for (int i = 0; i < tierTTLStr.length; ++i) {
            tierTTLStr[i] = String.valueOf(this.config.getTierTTLInMs()[i]);
        }
        tierTTLStr = properties.getProperty("tier_ttl_in_ms", String.join((CharSequence)";", tierTTLStr)).split(";");
        long[] tierTTL = new long[tierTTLStr.length];
        for (int i = 0; i < tierTTL.length; ++i) {
            tierTTL[i] = Long.parseLong((String)tierTTLStr[i]);
            if (tierTTL[i] >= 0L) continue;
            tierTTL[i] = Long.MAX_VALUE;
        }
        this.config.setTierTTLInMs(tierTTL);
        this.config.setSyncDir(properties.getProperty("dn_sync_dir", this.config.getSyncDir()).trim());
        this.config.setWalDirs(properties.getProperty("dn_wal_dirs", String.join((CharSequence)",", this.config.getWalDirs())).trim().split(","));
        this.config.setRpcThriftCompressionEnabled(Boolean.parseBoolean(properties.getProperty("cn_rpc_thrift_compression_enable", String.valueOf(this.config.isRpcThriftCompressionEnabled())).trim()));
        this.config.setConnectionTimeoutInMS(Integer.parseInt(properties.getProperty("cn_connection_timeout_ms", String.valueOf(this.config.getConnectionTimeoutInMS())).trim()));
        this.config.setSelectorNumOfClientManager(Integer.parseInt(properties.getProperty("cn_selector_thread_nums_of_client_manager", String.valueOf(this.config.getSelectorNumOfClientManager())).trim()));
        this.config.setMaxClientNumForEachNode(Integer.parseInt(properties.getProperty("cn_max_client_count_for_each_node_in_client_manager", String.valueOf(this.config.getMaxClientNumForEachNode())).trim()));
        this.config.setConnectionTimeoutInMS(Integer.parseInt(properties.getProperty("dn_connection_timeout_ms", String.valueOf(this.config.getConnectionTimeoutInMS())).trim()));
        this.config.setRpcThriftCompressionEnabled(Boolean.parseBoolean(properties.getProperty("dn_rpc_thrift_compression_enable", String.valueOf(this.config.isRpcThriftCompressionEnabled())).trim()));
        this.config.setSelectorNumOfClientManager(Integer.parseInt(properties.getProperty("dn_selector_thread_nums_of_client_manager", String.valueOf(this.config.getSelectorNumOfClientManager())).trim()));
        this.config.setMaxClientNumForEachNode(Integer.parseInt(properties.getProperty("dn_max_client_count_for_each_node_in_client_manager", String.valueOf(this.config.getMaxClientNumForEachNode())).trim()));
        this.config.setHandleSystemErrorStrategy(HandleSystemErrorStrategy.valueOf(properties.getProperty("handle_system_error", String.valueOf((Object)this.config.getHandleSystemErrorStrategy())).trim()));
        this.config.setDiskSpaceWarningThreshold(Double.parseDouble(properties.getProperty("disk_space_warning_threshold", String.valueOf(this.config.getDiskSpaceWarningThreshold())).trim()));
        this.config.setTimestampPrecision(properties.getProperty("timestamp_precision", this.config.getTimestampPrecision()).trim());
        this.config.setTimestampPrecisionCheckEnabled(Boolean.parseBoolean(properties.getProperty("timestamp_precision_check_enabled", String.valueOf(this.config.isTimestampPrecisionCheckEnabled()))));
        this.config.setDatanodeTokenTimeoutMS(Integer.parseInt(properties.getProperty("datanode_token_timeout", String.valueOf(180000))));
        this.loadPipeProps(properties);
        this.loadSubscriptionProps(properties);
        this.config.setSchemaEngineMode(properties.getProperty("schema_engine_mode", String.valueOf(this.config.getSchemaEngineMode())));
        this.config.setLastCacheEnable(Boolean.parseBoolean(properties.getProperty("enable_last_cache", Boolean.toString(this.config.isLastCacheEnable()))));
        this.config.setTagAttributeTotalSize(Integer.parseInt(properties.getProperty("tag_attribute_total_size", String.valueOf(this.config.getTagAttributeTotalSize()))));
        this.config.setTimePartitionOrigin(Long.parseLong(properties.getProperty("time_partition_origin", String.valueOf(this.config.getTimePartitionOrigin()))));
        this.config.setTimePartitionInterval(Long.parseLong(properties.getProperty("time_partition_interval", String.valueOf(this.config.getTimePartitionInterval()))));
        this.config.setDatabaseLimitThreshold(Integer.parseInt(properties.getProperty("database_limit_threshold", String.valueOf(this.config.getDatabaseLimitThreshold()))));
        this.config.setSeriesLimitThreshold(Long.parseLong(properties.getProperty("cluster_timeseries_limit_threshold", String.valueOf(this.config.getSeriesLimitThreshold()))));
        this.config.setDeviceLimitThreshold(Long.parseLong(properties.getProperty("cluster_device_limit_threshold", String.valueOf(this.config.getDeviceLimitThreshold()))));
        this.loadRetryProperties(properties);
    }

    private void loadPipeProps(Properties properties) {
        this.config.setPipeNonForwardingEventsProgressReportInterval(Integer.parseInt(properties.getProperty("pipe_non_forwarding_events_progress_report_interval", Integer.toString(this.config.getPipeNonForwardingEventsProgressReportInterval()))));
        this.config.setPipeHardlinkBaseDirName(properties.getProperty("pipe_hardlink_base_dir_name", this.config.getPipeHardlinkBaseDirName()));
        this.config.setPipeHardlinkTsFileDirName(properties.getProperty("pipe_hardlink_tsfile_dir_name", this.config.getPipeHardlinkTsFileDirName()));
        this.config.setPipeHardlinkWALDirName(properties.getProperty("pipe_hardlink_wal_dir_name", this.config.getPipeHardlinkWALDirName()));
        this.config.setPipeHardLinkWALEnabled(Boolean.parseBoolean(properties.getProperty("pipe_hardlink_wal_enabled", Boolean.toString(this.config.getPipeHardLinkWALEnabled()))));
        this.config.setPipeDataStructureTabletRowSize(Integer.parseInt(properties.getProperty("pipe_data_structure_tablet_row_size", String.valueOf(this.config.getPipeDataStructureTabletRowSize()))));
        this.config.setPipeDataStructureTabletSizeInBytes(Integer.parseInt(properties.getProperty("pipe_data_structure_tablet_size_in_bytes", String.valueOf(this.config.getPipeDataStructureTabletSizeInBytes()))));
        this.config.setPipeDataStructureTabletMemoryBlockAllocationRejectThreshold(Double.parseDouble(properties.getProperty("pipe_data_structure_tablet_memory_block_allocation_reject_threshold", String.valueOf(this.config.getPipeDataStructureTabletMemoryBlockAllocationRejectThreshold()))));
        this.config.setPipeRealTimeQueuePollHistoryThreshold(Integer.parseInt(properties.getProperty("pipe_realtime_queue_poll_history_threshold", Integer.toString(this.config.getPipeRealTimeQueuePollHistoryThreshold()))));
        this.config.setPipeSubtaskExecutorMaxThreadNum(Integer.parseInt(properties.getProperty("pipe_subtask_executor_max_thread_num", Integer.toString(this.config.getPipeSubtaskExecutorMaxThreadNum()))));
        if (this.config.getPipeSubtaskExecutorMaxThreadNum() <= 0) {
            this.config.setPipeSubtaskExecutorMaxThreadNum(5);
        }
        this.config.setPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount(Integer.parseInt(properties.getProperty("pipe_subtask_executor_basic_check_point_interval_by_consumed_event_count", String.valueOf(this.config.getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount()))));
        this.config.setPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration(Long.parseLong(properties.getProperty("pipe_subtask_executor_basic_check_point_interval_by_time_duration", String.valueOf(this.config.getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration()))));
        this.config.setPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs(Long.parseLong(properties.getProperty("pipe_subtask_executor_pending_queue_max_blocking_time_ms", String.valueOf(this.config.getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs()))));
        this.config.setPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds(Long.parseLong(properties.getProperty("pipe_subtask_executor_cron_heartbeat_event_interval_seconds", String.valueOf(this.config.getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds()))));
        this.config.setPipeSubtaskExecutorForcedRestartIntervalMs(Long.parseLong(properties.getProperty("pipe_subtask_executor_forced_restart_interval_ms", String.valueOf(this.config.getPipeSubtaskExecutorForcedRestartIntervalMs()))));
        this.config.setPipeExtractorAssignerDisruptorRingBufferSize(Integer.parseInt(Optional.ofNullable(properties.getProperty("pipe_source_assigner_disruptor_ring_buffer_size")).orElse(properties.getProperty("pipe_extractor_assigner_disruptor_ring_buffer_size", String.valueOf(this.config.getPipeExtractorAssignerDisruptorRingBufferSize())))));
        this.config.setPipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes(Integer.parseInt(Optional.ofNullable(properties.getProperty("pipe_source_assigner_disruptor_ring_buffer_entry_size_in_bytes")).orElse(properties.getProperty("pipe_extractor_assigner_disruptor_ring_buffer_entry_size_in_bytes", String.valueOf(this.config.getPipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes())))));
        this.config.setPipeExtractorMatcherCacheSize(Integer.parseInt(Optional.ofNullable(properties.getProperty("pipe_source_matcher_cache_size")).orElse(properties.getProperty("pipe_extractor_matcher_cache_size", String.valueOf(this.config.getPipeExtractorMatcherCacheSize())))));
        this.config.setPipeConnectorHandshakeTimeoutMs(Long.parseLong(Optional.ofNullable(properties.getProperty("pipe_sink_handshake_timeout_ms")).orElse(properties.getProperty("pipe_connector_handshake_timeout_ms", String.valueOf(this.config.getPipeConnectorHandshakeTimeoutMs())))));
        this.config.setPipeConnectorTransferTimeoutMs(Long.parseLong(Optional.ofNullable(properties.getProperty("pipe_sink_timeout_ms")).orElse(properties.getProperty("pipe_connector_timeout_ms", String.valueOf(this.config.getPipeConnectorTransferTimeoutMs())))));
        this.config.setPipeConnectorReadFileBufferSize(Integer.parseInt(Optional.ofNullable(properties.getProperty("pipe_sink_read_file_buffer_size")).orElse(properties.getProperty("pipe_connector_read_file_buffer_size", String.valueOf(this.config.getPipeConnectorReadFileBufferSize())))));
        this.config.setPipeConnectorRetryIntervalMs(Long.parseLong(Optional.ofNullable(properties.getProperty("pipe_sink_retry_interval_ms")).orElse(properties.getProperty("pipe_connector_retry_interval_ms", String.valueOf(this.config.getPipeConnectorRetryIntervalMs())))));
        this.config.setPipeConnectorRPCThriftCompressionEnabled(Boolean.parseBoolean(Optional.ofNullable(properties.getProperty("pipe_sink_rpc_thrift_compression_enabled")).orElse(properties.getProperty("pipe_connector_rpc_thrift_compression_enabled", String.valueOf(this.config.isPipeConnectorRPCThriftCompressionEnabled())))));
        this.config.setPipeAsyncConnectorSelectorNumber(Integer.parseInt(Optional.ofNullable(properties.getProperty("pipe_sink_selector_number")).orElse(properties.getProperty("pipe_async_connector_selector_number", String.valueOf(this.config.getPipeAsyncConnectorSelectorNumber())))));
        this.config.setPipeAsyncConnectorMaxClientNumber(Integer.parseInt(Optional.ofNullable(properties.getProperty("pipe_sink_max_client_number")).orElse(properties.getProperty("pipe_async_connector_max_client_number", String.valueOf(this.config.getPipeAsyncConnectorMaxClientNumber())))));
        this.config.setPipeAllSinksRateLimitBytesPerSecond(Double.parseDouble(properties.getProperty("pipe_all_sinks_rate_limit_bytes_per_second", String.valueOf(this.config.getPipeAllSinksRateLimitBytesPerSecond()))));
        this.config.setRateLimiterHotReloadCheckIntervalMs(Integer.parseInt(properties.getProperty("rate_limiter_hot_reload_check_interval_ms", String.valueOf(this.config.getRateLimiterHotReloadCheckIntervalMs()))));
        this.config.setPipeConnectorRequestSliceThresholdBytes(Integer.parseInt(properties.getProperty("pipe_connector_request_slice_threshold_bytes", String.valueOf(this.config.getPipeConnectorRequestSliceThresholdBytes()))));
        this.config.setSeperatedPipeHeartbeatEnabled(Boolean.parseBoolean(properties.getProperty("pipe_heartbeat_seperated_mode_enabled", String.valueOf(this.config.isSeperatedPipeHeartbeatEnabled()))));
        this.config.setPipeHeartbeatIntervalSecondsForCollectingPipeMeta(Integer.parseInt(properties.getProperty("pipe_heartbeat_interval_seconds_for_collecting_pipe_meta", String.valueOf(this.config.getPipeHeartbeatIntervalSecondsForCollectingPipeMeta()))));
        this.config.setPipeMetaSyncerInitialSyncDelayMinutes(Long.parseLong(properties.getProperty("pipe_meta_syncer_initial_sync_delay_minutes", String.valueOf(this.config.getPipeMetaSyncerInitialSyncDelayMinutes()))));
        this.config.setPipeMetaSyncerSyncIntervalMinutes(Long.parseLong(properties.getProperty("pipe_meta_syncer_sync_interval_minutes", String.valueOf(this.config.getPipeMetaSyncerSyncIntervalMinutes()))));
        this.config.setPipeMetaSyncerAutoRestartPipeCheckIntervalRound(Long.parseLong(properties.getProperty("pipe_meta_syncer_auto_restart_pipe_check_interval_round", String.valueOf(this.config.getPipeMetaSyncerAutoRestartPipeCheckIntervalRound()))));
        this.config.setPipeAutoRestartEnabled(Boolean.parseBoolean(properties.getProperty("pipe_auto_restart_enabled", String.valueOf(this.config.getPipeAutoRestartEnabled()))));
        this.config.setPipeAirGapReceiverEnabled(Boolean.parseBoolean(properties.getProperty("pipe_air_gap_receiver_enabled", Boolean.toString(this.config.getPipeAirGapReceiverEnabled()))));
        this.config.setPipeAirGapReceiverPort(Integer.parseInt(properties.getProperty("pipe_air_gap_receiver_port", Integer.toString(this.config.getPipeAirGapReceiverPort()))));
        this.config.setPipeMaxAllowedHistoricalTsFilePerDataRegion(Integer.parseInt(properties.getProperty("pipe_max_allowed_historical_tsfile_per_data_region", String.valueOf(this.config.getPipeMaxAllowedHistoricalTsFilePerDataRegion()))));
        this.config.setPipeMaxAllowedPendingTsFileEpochPerDataRegion(Integer.parseInt(properties.getProperty("pipe_max_allowed_pending_tsfile_epoch_per_data_region", String.valueOf(this.config.getPipeMaxAllowedPendingTsFileEpochPerDataRegion()))));
        this.config.setPipeMaxAllowedPinnedMemTableCount(Integer.parseInt(properties.getProperty("pipe_max_allowed_pinned_memtable_count", String.valueOf(this.config.getPipeMaxAllowedPinnedMemTableCount()))));
        this.config.setPipeMaxAllowedLinkedTsFileCount(Long.parseLong(properties.getProperty("pipe_max_allowed_linked_tsfile_count", String.valueOf(this.config.getPipeMaxAllowedLinkedTsFileCount()))));
        this.config.setPipeMaxAllowedLinkedDeletedTsFileDiskUsagePercentage(Float.parseFloat(properties.getProperty("pipe_max_allowed_linked_deleted_tsfile_disk_usage_percentage", String.valueOf(this.config.getPipeMaxAllowedLinkedDeletedTsFileDiskUsagePercentage()))));
        this.config.setPipeStuckRestartIntervalSeconds(Long.parseLong(properties.getProperty("pipe_stuck_restart_interval_seconds", String.valueOf(this.config.getPipeStuckRestartIntervalSeconds()))));
        this.config.setPipeMetaReportMaxLogNumPerRound(Integer.parseInt(properties.getProperty("pipe_meta_report_max_log_num_per_round", String.valueOf(this.config.getPipeMetaReportMaxLogNumPerRound()))));
        this.config.setPipeMetaReportMaxLogIntervalRounds(Integer.parseInt(properties.getProperty("pipe_meta_report_max_log_interval_rounds", String.valueOf(this.config.getPipeMetaReportMaxLogIntervalRounds()))));
        this.config.setPipeTsFilePinMaxLogNumPerRound(Integer.parseInt(properties.getProperty("pipe_tsfile_pin_max_log_num_per_round", String.valueOf(this.config.getPipeTsFilePinMaxLogNumPerRound()))));
        this.config.setPipeTsFilePinMaxLogIntervalRounds(Integer.parseInt(properties.getProperty("pipe_tsfile_pin_max_log_interval_rounds", String.valueOf(this.config.getPipeTsFilePinMaxLogIntervalRounds()))));
        this.config.setPipeWalPinMaxLogNumPerRound(Integer.parseInt(properties.getProperty("pipe_wal_pin_max_log_num_per_round", String.valueOf(this.config.getPipeWalPinMaxLogNumPerRound()))));
        this.config.setPipeWalPinMaxLogIntervalRounds(Integer.parseInt(properties.getProperty("pipe_wal_pin_max_log_interval_rounds", String.valueOf(this.config.getPipeWalPinMaxLogIntervalRounds()))));
        this.config.setPipeMemoryManagementEnabled(Boolean.parseBoolean(properties.getProperty("pipe_memory_management_enabled", String.valueOf(this.config.getPipeMemoryManagementEnabled()))));
        this.config.setPipeMemoryAllocateMaxRetries(Integer.parseInt(properties.getProperty("pipe_memory_allocate_max_retries", String.valueOf(this.config.getPipeMemoryAllocateMaxRetries()))));
        this.config.setPipeMemoryAllocateRetryIntervalInMs(Long.parseLong(properties.getProperty("pipe_memory_allocate_retry_interval_in_ms", String.valueOf(this.config.getPipeMemoryAllocateRetryIntervalInMs()))));
        this.config.setPipeMemoryAllocateMinSizeInBytes(Long.parseLong(properties.getProperty("pipe_memory_allocate_min_size_in_bytes", String.valueOf(this.config.getPipeMemoryAllocateMinSizeInBytes()))));
        this.config.setPipeMemoryAllocateForTsFileSequenceReaderInBytes(Long.parseLong(properties.getProperty("pipe_memory_allocate_for_tsfile_sequence_reader_in_bytes", String.valueOf(this.config.getPipeMemoryAllocateForTsFileSequenceReaderInBytes()))));
        this.config.setPipeMemoryExpanderIntervalSeconds(Long.parseLong(properties.getProperty("pipe_memory_expander_interval_seconds", String.valueOf(this.config.getPipeMemoryExpanderIntervalSeconds()))));
        this.config.setPipeLeaderCacheMemoryUsagePercentage(Float.parseFloat(properties.getProperty("pipe_leader_cache_memory_usage_percentage", String.valueOf(this.config.getPipeLeaderCacheMemoryUsagePercentage()))));
        this.config.setPipeListeningQueueTransferSnapshotThreshold(Long.parseLong(properties.getProperty("pipe_listening_queue_transfer_snapshot_threshold", String.valueOf(this.config.getPipeListeningQueueTransferSnapshotThreshold()))));
        this.config.setPipeSnapshotExecutionMaxBatchSize(Integer.parseInt(properties.getProperty("pipe_snapshot_execution_max_batch_size", String.valueOf(this.config.getPipeSnapshotExecutionMaxBatchSize()))));
        this.config.setPipeRemainingTimeCommitRateAutoSwitchSeconds(Long.parseLong(properties.getProperty("pipe_remaining_time_commit_rate_auto_switch_seconds", String.valueOf(this.config.getPipeRemainingTimeCommitRateAutoSwitchSeconds()))));
        this.config.setPipeRemainingTimeCommitRateAverageTime(PipeRemainingTimeRateAverageTime.valueOf(properties.getProperty("pipe_remaining_time_commit_rate_average_time", String.valueOf((Object)this.config.getPipeRemainingTimeCommitRateAverageTime())).trim()));
        this.config.setPipeTsFileScanParsingThreshold(Double.parseDouble(properties.getProperty("pipe_tsfile_scan_parsing_threshold", String.valueOf(this.config.getPipeTsFileScanParsingThreshold()))));
        this.config.setTwoStageAggregateMaxCombinerLiveTimeInMs(Long.parseLong(properties.getProperty("two_stage_aggregate_max_combiner_live_time_in_ms", String.valueOf(this.config.getTwoStageAggregateMaxCombinerLiveTimeInMs()))));
        this.config.setTwoStageAggregateDataRegionInfoCacheTimeInMs(Long.parseLong(properties.getProperty("two_stage_aggregate_data_region_info_cache_time_in_ms", String.valueOf(this.config.getTwoStageAggregateDataRegionInfoCacheTimeInMs()))));
        this.config.setTwoStageAggregateSenderEndPointsCacheInMs(Long.parseLong(properties.getProperty("two_stage_aggregate_sender_end_points_cache_in_ms", String.valueOf(this.config.getTwoStageAggregateSenderEndPointsCacheInMs()))));
    }

    private void loadSubscriptionProps(Properties properties) {
        this.config.setSubscriptionCacheMemoryUsagePercentage(Float.parseFloat(properties.getProperty("subscription_cache_memory_usage_percentage", String.valueOf(this.config.getSubscriptionCacheMemoryUsagePercentage()))));
        this.config.setSubscriptionSubtaskExecutorMaxThreadNum(Integer.parseInt(properties.getProperty("subscription_subtask_executor_max_thread_num", Integer.toString(this.config.getSubscriptionSubtaskExecutorMaxThreadNum()))));
        if (this.config.getSubscriptionSubtaskExecutorMaxThreadNum() <= 0) {
            this.config.setSubscriptionSubtaskExecutorMaxThreadNum(5);
        }
        this.config.setSubscriptionPrefetchTabletBatchMaxDelayInMs(Integer.parseInt(properties.getProperty("subscription_prefetch_tablet_batch_max_delay_in_ms", String.valueOf(this.config.getSubscriptionPrefetchTabletBatchMaxDelayInMs()))));
        this.config.setSubscriptionPrefetchTabletBatchMaxSizeInBytes(Long.parseLong(properties.getProperty("subscription_prefetch_tablet_batch_max_size_in_bytes", String.valueOf(this.config.getSubscriptionPrefetchTabletBatchMaxSizeInBytes()))));
        this.config.setSubscriptionPrefetchTsFileBatchMaxDelayInMs(Integer.parseInt(properties.getProperty("subscription_prefetch_ts_file_batch_max_delay_in_ms", String.valueOf(this.config.getSubscriptionPrefetchTsFileBatchMaxDelayInMs()))));
        this.config.setSubscriptionPrefetchTsFileBatchMaxSizeInBytes(Long.parseLong(properties.getProperty("subscription_prefetch_ts_file_batch_max_size_in_bytes", String.valueOf(this.config.getSubscriptionPrefetchTsFileBatchMaxSizeInBytes()))));
        this.config.setSubscriptionPollMaxBlockingTimeMs(Integer.parseInt(properties.getProperty("subscription_poll_max_blocking_time_ms", String.valueOf(this.config.getSubscriptionPollMaxBlockingTimeMs()))));
        this.config.setSubscriptionSerializeMaxBlockingTimeMs(Integer.parseInt(properties.getProperty("subscription_serialize_max_blocking_time_ms", String.valueOf(this.config.getSubscriptionSerializeMaxBlockingTimeMs()))));
        this.config.setSubscriptionLaunchRetryIntervalMs(Long.parseLong(properties.getProperty("subscription_launch_retry_interval_ms", String.valueOf(this.config.getSubscriptionLaunchRetryIntervalMs()))));
        this.config.setSubscriptionRecycleUncommittedEventIntervalMs(Integer.parseInt(properties.getProperty("subscription_recycle_uncommitted_event_interval_ms", String.valueOf(this.config.getSubscriptionRecycleUncommittedEventIntervalMs()))));
        this.config.setSubscriptionReadFileBufferSize(Long.parseLong(properties.getProperty("subscription_read_file_buffer_size", String.valueOf(this.config.getSubscriptionReadFileBufferSize()))));
        this.config.setSubscriptionReadTabletBufferSize(Long.parseLong(properties.getProperty("subscription_read_tablet_buffer_size", String.valueOf(this.config.getSubscriptionReadTabletBufferSize()))));
        this.config.setSubscriptionTsFileDeduplicationWindowSeconds(Long.parseLong(properties.getProperty("subscription_ts_file_deduplication_window_seconds", String.valueOf(this.config.getSubscriptionTsFileDeduplicationWindowSeconds()))));
    }

    public void loadRetryProperties(Properties properties) throws IOException {
        this.config.setRemoteWriteMaxRetryDurationInMs(Long.parseLong(properties.getProperty("write_request_remote_dispatch_max_retry_duration_in_ms", ConfigurationFileUtils.getConfigurationDefaultValue("write_request_remote_dispatch_max_retry_duration_in_ms"))));
        this.config.setRetryForUnknownErrors(Boolean.parseBoolean(properties.getProperty("enable_retry_for_unknown_error", ConfigurationFileUtils.getConfigurationDefaultValue("enable_retry_for_unknown_error"))));
    }

    public void loadGlobalConfig(TGlobalConfig globalConfig) {
        this.config.setTimestampPrecision(globalConfig.timestampPrecision);
        this.config.setTimePartitionOrigin(CommonDateTimeUtils.convertMilliTimeWithPrecision(globalConfig.timePartitionOrigin, this.config.getTimestampPrecision()));
        this.config.setTimePartitionInterval(CommonDateTimeUtils.convertMilliTimeWithPrecision(globalConfig.timePartitionInterval, this.config.getTimestampPrecision()));
        this.config.setSchemaEngineMode(globalConfig.schemaEngineMode);
        this.config.setTagAttributeTotalSize(globalConfig.tagAttributeTotalSize);
        this.config.setDiskSpaceWarningThreshold(globalConfig.getDiskSpaceWarningThreshold());
    }

    private static class CommonDescriptorHolder {
        private static final CommonDescriptor INSTANCE = new CommonDescriptor();

        private CommonDescriptorHolder() {
        }
    }
}

