/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client;

import java.util.Optional;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.exception.BorrowNullClientManagerException;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientManager<K, V>
implements IClientManager<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientManager.class);
    private final KeyedObjectPool<K, V> pool;

    ClientManager(IClientPoolFactory<K, V> factory) {
        this.pool = factory.createClientPool(this);
    }

    public KeyedObjectPool<K, V> getPool() {
        return this.pool;
    }

    @Override
    public V borrowClient(K node) throws ClientManagerException {
        if (node == null) {
            throw new BorrowNullClientManagerException();
        }
        try {
            return (V)this.pool.borrowObject(node);
        }
        catch (Exception e) {
            throw new ClientManagerException(e);
        }
    }

    public void returnClient(K node, V client) {
        Optional.ofNullable(node).ifPresent(x -> {
            try {
                this.pool.returnObject(node, client);
            }
            catch (Exception e) {
                LOGGER.warn("Return client {} for node {} to pool failed.", new Object[]{client, node, e});
            }
        });
    }

    @Override
    public void clear(K node) {
        Optional.ofNullable(node).ifPresent(x -> {
            try {
                this.pool.clear(node);
            }
            catch (Exception e) {
                LOGGER.warn("Clear all client in pool for node {} failed.", node, (Object)e);
            }
        });
    }

    @Override
    public void close() {
        this.pool.close();
    }
}

