/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.poll;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.rpc.subscription.payload.poll.ErrorPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.FileInitPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.FilePiecePayload;
import org.apache.iotdb.rpc.subscription.payload.poll.FileSealPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponseType;
import org.apache.iotdb.rpc.subscription.payload.poll.TabletsPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.TerminationPayload;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPollResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPollResponse.class);
    private final transient short responseType;
    private final transient SubscriptionPollPayload payload;
    private final transient SubscriptionCommitContext commitContext;

    public SubscriptionPollResponse(short responseType, SubscriptionPollPayload payload, SubscriptionCommitContext commitContext) {
        this.responseType = responseType;
        this.payload = payload;
        this.commitContext = commitContext;
    }

    public short getResponseType() {
        return this.responseType;
    }

    public SubscriptionPollPayload getPayload() {
        return this.payload;
    }

    public SubscriptionCommitContext getCommitContext() {
        return this.commitContext;
    }

    public static ByteBuffer serialize(SubscriptionPollResponse response) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                response.serialize(outputStream);
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            return byteBuffer;
        }
    }

    private void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)this.responseType, (OutputStream)stream);
        this.payload.serialize(stream);
        this.commitContext.serialize(stream);
    }

    public static SubscriptionPollResponse deserialize(ByteBuffer buffer) {
        short responseType = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
        SubscriptionPollPayload payload = null;
        if (SubscriptionPollResponseType.isValidatedResponseType(responseType)) {
            switch (SubscriptionPollResponseType.valueOf(responseType)) {
                case TABLETS: {
                    payload = new TabletsPayload().deserialize(buffer);
                    break;
                }
                case FILE_INIT: {
                    payload = new FileInitPayload().deserialize(buffer);
                    break;
                }
                case FILE_PIECE: {
                    payload = new FilePiecePayload().deserialize(buffer);
                    break;
                }
                case FILE_SEAL: {
                    payload = new FileSealPayload().deserialize(buffer);
                    break;
                }
                case ERROR: {
                    payload = new ErrorPayload().deserialize(buffer);
                    break;
                }
                case TERMINATION: {
                    payload = new TerminationPayload().deserialize(buffer);
                    break;
                }
                default: {
                    LOGGER.warn("unexpected response type: {}, payload will be null", (Object)responseType);
                    break;
                }
            }
        } else {
            LOGGER.warn("unexpected response type: {}, payload will be null", (Object)responseType);
        }
        SubscriptionCommitContext commitContext = SubscriptionCommitContext.deserialize(buffer);
        return new SubscriptionPollResponse(responseType, payload, commitContext);
    }

    public String toString() {
        return "SubscriptionPollResponse{responseType=" + SubscriptionPollResponseType.valueOf(this.responseType).toString() + ", payload=" + this.payload + ", commitContext=" + this.commitContext + "}";
    }
}

