/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.string;

import java.io.IOException;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFStrReplace
implements UDTF {
    private String target;
    private String replace;
    private int limit;
    private int offset;
    private boolean reverse;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.TEXT).validate(target -> ((String)target).length() > 0, "target should not be empty", (Object)validator.getParameters().getString("target")).validate(limit -> (Integer)limit >= -1, "limit has to be -1 for replacing all matches or non-negative integers for limited times.", (Object)validator.getParameters().getIntOrDefault("limit", -1)).validate(offset -> (Integer)offset >= 0, "offset has to be non-negative to skip first several matches.", (Object)validator.getParameters().getIntOrDefault("offset", 0));
    }

    @Override
    public void beforeStart(UDFParameters udfParameters, UDTFConfigurations udtfConfigurations) throws Exception {
        this.target = udfParameters.getString("target");
        this.replace = udfParameters.getString("replace");
        this.limit = udfParameters.getIntOrDefault("limit", -1);
        this.offset = udfParameters.getIntOrDefault("offset", 0);
        this.reverse = udfParameters.getBooleanOrDefault("reverse", false);
        udtfConfigurations.setAccessStrategy(new MappableRowByRowAccessStrategy()).setOutputDataType(Type.TEXT);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        String origin = row.getString(0);
        String result = this.getResult(origin);
        collector.putString(row.getTime(), result);
    }

    @Override
    public Object transform(Row row) throws IOException {
        if (row.isNull(0)) {
            return null;
        }
        String str = row.getString(0);
        return this.getResult(str);
    }

    @Override
    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        Binary[] inputs = columns[0].getBinaries();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            String str = inputs[i].toString();
            builder.writeBinary(new Binary(this.getResult(str).getBytes()));
        }
    }

    private String getResult(String origin) {
        String result;
        if (this.reverse) {
            int matchIndex;
            int matchIndex2;
            int count;
            int endIndex = origin.length();
            for (count = 0; count < this.offset && (matchIndex2 = origin.lastIndexOf(this.target, endIndex - 1)) != -1; ++count) {
                endIndex = matchIndex2;
            }
            if (count < this.offset) {
                endIndex = 0;
            }
            String suffix = origin.substring(endIndex);
            while (count < this.offset + this.limit && (matchIndex = origin.lastIndexOf(this.target, endIndex - 1)) != -1) {
                endIndex = matchIndex;
                ++count;
            }
            if (this.limit == -1 || count < this.offset + this.limit) {
                endIndex = 0;
            }
            String prefix = origin.substring(0, endIndex);
            result = prefix.concat(origin.substring(endIndex, origin.length() - suffix.length()).replace(this.target, this.replace)).concat(suffix);
        } else {
            int matchIndex;
            int matchIndex3;
            int count;
            int fromIndex = 0;
            for (count = 0; count < this.offset && (matchIndex3 = origin.indexOf(this.target, fromIndex)) != -1; ++count) {
                fromIndex = matchIndex3 + this.target.length();
            }
            if (count < this.offset) {
                fromIndex = origin.length();
            }
            String prefix = origin.substring(0, fromIndex);
            while (count < this.offset + this.limit && (matchIndex = origin.indexOf(this.target, fromIndex)) != -1) {
                fromIndex = matchIndex + this.target.length();
                ++count;
            }
            if (this.limit == -1 || count < this.offset + this.limit) {
                fromIndex = origin.length();
            }
            String suffix = origin.substring(fromIndex);
            result = prefix.concat(origin.substring(prefix.length(), fromIndex).replace(this.target, this.replace)).concat(suffix);
        }
        return result;
    }
}

