/*
 * Decompiled with CFR 0.152.
 */
package com.github.ggalmazor.ltdownsampling;

import com.github.ggalmazor.ltdownsampling.Point;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

class Bucket<T extends Point> {
    private final List<T> data;
    private final T first;
    private final T last;
    private final Point center;
    private T result = null;

    private Bucket(List<T> data, T first, T last, Point center) {
        this.data = data;
        this.first = first;
        this.last = last;
        this.center = center;
    }

    static <U extends Point> Bucket<U> of(List<U> us) {
        Point first = (Point)us.get(0);
        Point last = (Point)us.get(us.size() - 1);
        Point center = first.add(last.subtract(first).divide(2));
        return new Bucket<Point>(us, first, last, center);
    }

    static <U extends Point> Bucket<U> of(U u) {
        return new Bucket<U>(Collections.singletonList(u), u, u, u);
    }

    T getResult() {
        return this.result != null ? this.result : this.first;
    }

    void setResult(T result) {
        this.result = result;
    }

    T getFirst() {
        return this.first;
    }

    T getLast() {
        return this.last;
    }

    Point getCenter() {
        return this.center;
    }

    <U> List<U> map(Function<T, U> mapper) {
        return this.data.stream().map(mapper).collect(Collectors.toList());
    }
}

