/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.Timer;
import io.micrometer.observation.Observation;
import io.micrometer.observation.transport.RequestReplyReceiverContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.netty.Metrics;
import reactor.netty.ReactorNetty;
import reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerObservations;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import reactor.netty.observability.ReactorNettyHandlerContext;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

final class MicrometerHttpServerMetricsHandler
extends AbstractHttpServerMetricsHandler {
    final MicrometerHttpServerMetricsRecorder recorder;
    final String responseTimeName;
    ResponseTimeHandlerContext responseTimeHandlerContext;
    Observation responseTimeObservation;
    ContextView parentContextView;

    MicrometerHttpServerMetricsHandler(MicrometerHttpServerMetricsRecorder recorder, @Nullable Function<String, String> methodTagValue, @Nullable Function<String, String> uriTagValue) {
        super(methodTagValue, uriTagValue);
        this.recorder = recorder;
        this.responseTimeName = recorder.name() + ".response.time";
    }

    MicrometerHttpServerMetricsHandler(MicrometerHttpServerMetricsHandler copy) {
        super(copy);
        this.recorder = copy.recorder;
        this.responseTimeName = copy.responseTimeName;
        this.responseTimeHandlerContext = copy.responseTimeHandlerContext;
        this.responseTimeObservation = copy.responseTimeObservation;
        this.parentContextView = copy.parentContextView;
    }

    @Override
    protected HttpServerMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void recordWrite(HttpServerOperations ops, String path, String method, String status) {
        Duration dataSentTimeDuration = Duration.ofNanos(System.nanoTime() - this.dataSentTime);
        this.recorder().recordDataSentTime(path, method, status, dataSentTimeDuration);
        this.recorder().recordDataSent(ops.remoteAddress(), path, this.dataSent);
        this.responseTimeObservation.stop();
        ReactorNetty.setChannelContext(ops.channel(), this.parentContextView);
        this.responseTimeHandlerContext = null;
        this.responseTimeObservation = null;
        this.parentContextView = null;
    }

    @Override
    protected void startRead(HttpServerOperations ops, String path, String method) {
        super.startRead(ops, path, method);
        this.responseTimeHandlerContext = new ResponseTimeHandlerContext(this.recorder, method, path, ops);
        this.responseTimeObservation = Observation.createNotStarted(this.responseTimeName, this.responseTimeHandlerContext, Metrics.OBSERVATION_REGISTRY);
        this.parentContextView = Metrics.updateChannelContext(ops.channel(), this.responseTimeObservation);
        this.responseTimeObservation.start();
    }

    @Override
    protected void startWrite(HttpServerOperations ops, String path, String method, String status) {
        super.startWrite(ops, path, method, status);
        if (this.responseTimeObservation == null) {
            this.responseTimeHandlerContext = new ResponseTimeHandlerContext(this.recorder, method, path, ops);
            this.responseTimeObservation = Observation.createNotStarted(this.responseTimeName, this.responseTimeHandlerContext, Metrics.OBSERVATION_REGISTRY);
            this.parentContextView = Metrics.updateChannelContext(ops.channel(), this.responseTimeObservation);
            this.responseTimeObservation.start();
        }
        this.responseTimeHandlerContext.setResponse(ops.nettyResponse);
        this.responseTimeHandlerContext.status = status;
    }

    static final class ResponseTimeHandlerContext
    extends RequestReplyReceiverContext<HttpRequest, HttpResponse>
    implements ReactorNettyHandlerContext,
    Supplier<Observation.Context> {
        static final String TYPE = "server";
        final String method;
        final String netHostName;
        final String netHostPort;
        final String path;
        final MicrometerHttpServerMetricsRecorder recorder;
        final String scheme;
        String status = "UNKNOWN";

        ResponseTimeHandlerContext(MicrometerHttpServerMetricsRecorder recorder, String method, String path, HttpServerOperations ops) {
            super((carrier, key) -> Objects.requireNonNull(carrier).headers().get(key));
            this.recorder = recorder;
            HttpRequest request = ops.nettyRequest;
            this.method = method;
            InetSocketAddress hostAddress = ops.hostAddress();
            this.netHostName = hostAddress != null ? hostAddress.getHostString() : "";
            this.netHostPort = hostAddress != null ? hostAddress.getPort() + "" : "";
            this.path = path;
            this.scheme = ops.scheme;
            this.setCarrier(request);
            this.setContextualName(this.method + '_' + this.path.substring(1));
        }

        @Override
        public Observation.Context get() {
            return this;
        }

        @Override
        public Timer getTimer() {
            return this.recorder.getResponseTimeTimer(this.getName(), this.path, this.method, this.status);
        }

        @Override
        public KeyValues getHighCardinalityKeyValues() {
            return KeyValues.of(HttpServerObservations.ResponseTimeHighCardinalityTags.REACTOR_NETTY_TYPE.asString(), TYPE, HttpServerObservations.ResponseTimeHighCardinalityTags.HTTP_SCHEME.asString(), this.scheme, HttpServerObservations.ResponseTimeHighCardinalityTags.HTTP_STATUS_CODE.asString(), this.status, HttpServerObservations.ResponseTimeHighCardinalityTags.NET_HOST_NAME.asString(), this.netHostName, HttpServerObservations.ResponseTimeHighCardinalityTags.NET_HOST_PORT.asString(), this.netHostPort);
        }

        @Override
        public KeyValues getLowCardinalityKeyValues() {
            return KeyValues.of(HttpServerObservations.ResponseTimeLowCardinalityTags.METHOD.asString(), this.method, HttpServerObservations.ResponseTimeLowCardinalityTags.STATUS.asString(), this.status, HttpServerObservations.ResponseTimeLowCardinalityTags.URI.asString(), this.path);
        }
    }
}

