/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BytesUtils.class);

    private BytesUtils() {
    }

    public static byte[] intToBytes(int i) {
        return new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
    }

    public static byte[] intToBytes(int i, byte[] desc, int offset) {
        if (desc.length - offset < 4) {
            throw new IllegalArgumentException("Invalid input: desc.length - offset < 4");
        }
        desc[0 + offset] = (byte)(i >> 24 & 0xFF);
        desc[1 + offset] = (byte)(i >> 16 & 0xFF);
        desc[2 + offset] = (byte)(i >> 8 & 0xFF);
        desc[3 + offset] = (byte)(i & 0xFF);
        return desc;
    }

    public static void intToBytes(int srcNum, byte[] result, int pos, int width) {
        int cnt = pos & 7;
        int index = pos >> 3;
        try {
            while (width > 0) {
                int m4 = width + cnt >= 8 ? 8 - cnt : width;
                int mask = 1 << 8 - cnt;
                byte y = (byte)(srcNum >>> (width -= m4));
                y = (byte)(y << 8 - (cnt += m4));
                mask = ~(mask - (1 << 8 - cnt));
                result[index] = (byte)(result[index] & mask | y);
                srcNum &= ~(-1 << width);
                if (cnt != 8) continue;
                ++index;
                cnt = 0;
            }
        }
        catch (Exception e) {
            LOG.error("tsfile-common BytesUtils: cannot convert an integer {} to a byte array, pos {}, width {}", srcNum, pos, width, e);
        }
    }

    public static byte[] intToTwoBytes(int i) {
        if (i > 65535) {
            throw new IllegalArgumentException("Invalid input: " + i + " > 0xFFFF");
        }
        byte[] ret = new byte[2];
        ret[1] = (byte)(i & 0xFF);
        ret[0] = (byte)(i >> 8 & 0xFF);
        return ret;
    }

    public static int twoBytesToInt(byte[] ret) {
        if (ret.length != 2) {
            throw new IllegalArgumentException("Invalid input: ret.length != 2");
        }
        int value = 0;
        value |= ret[0];
        value <<= 8;
        return value |= ret[1];
    }

    public static int bytesToInt(byte[] bytes) {
        int length = bytes.length;
        long r = 0L;
        for (int i = 0; i < length; ++i) {
            r += (long)((bytes[length - 1 - i] & 0xFF) << i * 8);
        }
        if (r > Integer.MAX_VALUE) {
            throw new RuntimeException("Row count is larger than Integer.MAX_VALUE");
        }
        return (int)r;
    }

    public static int bytesToInt(byte[] bytes, int offset) {
        if (bytes.length - offset < 4) {
            throw new IllegalArgumentException("Invalid input: bytes.length - offset < 4");
        }
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (bytes[offset + i] & 0xFF) << shift;
        }
        return value;
    }

    public static int bytesToInt(byte[] result, int pos, int width) {
        int ret = 0;
        int cnt = pos & 7;
        int index = pos >> 3;
        while (width > 0) {
            int m4 = width + cnt >= 8 ? 8 - cnt : width;
            width -= m4;
            ret <<= m4;
            byte y = (byte)(result[index] & 255 >> cnt);
            y = (byte)((y & 0xFF) >>> 8 - cnt - m4);
            ret |= y & 0xFF;
            if ((cnt += m4) != 8) continue;
            cnt = 0;
            ++index;
        }
        return ret;
    }

    public static byte[] floatToBytes(float x) {
        byte[] b = new byte[4];
        int l = Float.floatToIntBits(x);
        for (int i = 3; i >= 0; --i) {
            b[i] = (byte)l;
            l >>= 8;
        }
        return b;
    }

    public static void floatToBytes(float x, byte[] desc, int offset) {
        if (desc.length - offset < 4) {
            throw new IllegalArgumentException("Invalid input: desc.length - offset < 4");
        }
        int l = Float.floatToIntBits(x);
        for (int i = 3 + offset; i >= offset; --i) {
            desc[i] = (byte)l;
            l >>= 8;
        }
    }

    public static float bytesToFloat(byte[] b) {
        if (b.length != 4) {
            throw new IllegalArgumentException("Invalid input: b.length != 4");
        }
        int l = b[3];
        l &= 0xFF;
        l = (int)((long)l | (long)b[2] << 8);
        l &= 0xFFFF;
        l = (int)((long)l | (long)b[1] << 16);
        l &= 0xFFFFFF;
        l = (int)((long)l | (long)b[0] << 24);
        return Float.intBitsToFloat(l);
    }

    public static float bytesToFloat(byte[] b, int offset) {
        if (b.length - offset < 4) {
            throw new IllegalArgumentException("Invalid input: b.length - offset < 4");
        }
        int l = b[offset + 3];
        l &= 0xFF;
        l = (int)((long)l | (long)b[offset + 2] << 8);
        l &= 0xFFFF;
        l = (int)((long)l | (long)b[offset + 1] << 16);
        l &= 0xFFFFFF;
        l = (int)((long)l | (long)b[offset] << 24);
        return Float.intBitsToFloat(l);
    }

    public static byte[] doubleToBytes(double data) {
        byte[] bytes = new byte[8];
        long value = Double.doubleToLongBits(data);
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)value;
            value >>= 8;
        }
        return bytes;
    }

    public static void doubleToBytes(double d, byte[] bytes, int offset) {
        if (bytes.length - offset < 8) {
            throw new IllegalArgumentException("Invalid input: bytes.length - offset < 8");
        }
        long value = Double.doubleToLongBits(d);
        for (int i = 7; i >= 0; --i) {
            bytes[offset + i] = (byte)value;
            value >>= 8;
        }
    }

    public static double bytesToDouble(byte[] bytes) {
        long value = bytes[7];
        value &= 0xFFL;
        value |= (long)bytes[6] << 8;
        value &= 0xFFFFL;
        value |= (long)bytes[5] << 16;
        value &= 0xFFFFFFL;
        value |= (long)bytes[4] << 24;
        value &= 0xFFFFFFFFL;
        value |= (long)bytes[3] << 32;
        value &= 0xFFFFFFFFFFL;
        value |= (long)bytes[2] << 40;
        value &= 0xFFFFFFFFFFFFL;
        value |= (long)bytes[1] << 48;
        value &= 0xFFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(value |= (long)bytes[0] << 56);
    }

    public static double bytesToDouble(byte[] bytes, int offset) {
        if (bytes.length - offset < 8) {
            throw new IllegalArgumentException("Invalid input: bytes.length - offset < 8");
        }
        long value = bytes[offset + 7];
        value &= 0xFFL;
        value |= (long)bytes[offset + 6] << 8;
        value &= 0xFFFFL;
        value |= (long)bytes[offset + 5] << 16;
        value &= 0xFFFFFFL;
        value |= (long)bytes[offset + 4] << 24;
        value &= 0xFFFFFFFFL;
        value |= (long)bytes[offset + 3] << 32;
        value &= 0xFFFFFFFFFFL;
        value |= (long)bytes[offset + 2] << 40;
        value &= 0xFFFFFFFFFFFFL;
        value |= (long)bytes[offset + 1] << 48;
        value &= 0xFFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(value |= (long)bytes[offset] << 56);
    }

    public static byte[] boolToBytes(boolean x) {
        byte[] b = new byte[]{x ? (byte)1 : 0};
        return b;
    }

    public static byte boolToByte(boolean x) {
        if (x) {
            return 1;
        }
        return 0;
    }

    public static boolean byteToBool(byte b) {
        return b == 1;
    }

    public static byte[] boolToBytes(boolean x, byte[] desc, int offset) {
        desc[offset] = x ? (byte)1 : 0;
        return desc;
    }

    public static boolean bytesToBool(byte[] b) {
        if (b.length != 1) {
            throw new IllegalArgumentException("Invalid input: b.length != 1");
        }
        return b[0] != 0;
    }

    public static boolean bytesToBool(byte[] b, int offset) {
        if (b.length - offset < 1) {
            throw new IllegalArgumentException("Invalid input: b.length - offset < 1");
        }
        return b[offset] != 0;
    }

    public static byte[] longToBytes(long num) {
        return BytesUtils.longToBytes(num, 8);
    }

    public static byte[] longToBytes(long num, int len) {
        byte[] byteNum = new byte[len];
        for (int ix = 0; ix < len; ++ix) {
            byteNum[len - ix - 1] = (byte)(num >> ix * 8 & 0xFFL);
        }
        return byteNum;
    }

    public static byte[] longToBytes(long num, byte[] desc, int offset) {
        for (int ix = 0; ix < 8; ++ix) {
            int i = 64 - (ix + 1) * 8;
            desc[ix + offset] = (byte)(num >> i & 0xFFL);
        }
        return desc;
    }

    public static void longToBytes(long srcNum, byte[] result, int pos, int width) {
        int cnt = pos & 7;
        int index = pos >> 3;
        try {
            while (width > 0) {
                int m4 = width + cnt >= 8 ? 8 - cnt : width;
                int mask = 1 << 8 - cnt;
                byte y = (byte)(srcNum >>> (width -= m4));
                y = (byte)(y << 8 - (cnt += m4));
                mask = ~(mask - (1 << 8 - cnt));
                result[index] = (byte)(result[index] & mask | y);
                srcNum &= -1L << width ^ 0xFFFFFFFFFFFFFFFFL;
                if (cnt != 8) continue;
                ++index;
                cnt = 0;
            }
        }
        catch (Exception e) {
            LOG.error("tsfile-common BytesUtils: cannot convert a long {} to a byte array, pos {}, width {}", srcNum, pos, width, e);
        }
    }

    public static long bytesToLong(byte[] byteNum) {
        return BytesUtils.bytesToLong(byteNum, byteNum.length);
    }

    public static long bytesToLong(byte[] byteNum, int len) {
        long num = 0L;
        for (int ix = 0; ix < len; ++ix) {
            num <<= 8;
            num |= (long)(byteNum[ix] & 0xFF);
        }
        return num;
    }

    public static long bytesToLong(byte[] result, int pos, int width) {
        long ret = 0L;
        int cnt = pos & 7;
        int index = pos >> 3;
        while (width > 0) {
            int m4 = width + cnt >= 8 ? 8 - cnt : width;
            width -= m4;
            ret <<= m4;
            byte y = (byte)(result[index] & 255 >> cnt);
            y = (byte)((y & 0xFF) >>> 8 - cnt - m4);
            ret |= (long)(y & 0xFF);
            if ((cnt += m4) != 8) continue;
            cnt = 0;
            ++index;
        }
        return ret;
    }

    public static long bytesToLongFromOffset(byte[] byteNum, int len, int offset) {
        if (byteNum.length - offset < len) {
            throw new IllegalArgumentException("Invalid input: byteNum.length - offset < len");
        }
        long num = 0L;
        for (int ix = 0; ix < len; ++ix) {
            num <<= 8;
            num |= (long)(byteNum[offset + ix] & 0xFF);
        }
        return num;
    }

    public static byte[] stringToBytes(String str) {
        return str.getBytes(TSFileConfig.STRING_CHARSET);
    }

    public static String bytesToString(byte[] byteStr) {
        return new String(byteStr, TSFileConfig.STRING_CHARSET);
    }

    public static byte[] concatByteArray(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] concatByteArrayList(List<byte[]> list) {
        int size = list.size();
        int len = 0;
        for (byte[] cs : list) {
            len += cs.length;
        }
        byte[] result = new byte[len];
        int pos = 0;
        for (int i = 0; i < size; ++i) {
            int l = list.get(i).length;
            System.arraycopy(list.get(i), 0, result, pos, l);
            pos += l;
        }
        return result;
    }

    public static byte[] deepCopy(byte[] src) {
        return BytesUtils.subBytes(src, 0, src.length);
    }

    public static byte[] subBytes(byte[] src, int start, int length) {
        if (start + length > src.length) {
            return new byte[0];
        }
        if (length <= 0) {
            return new byte[0];
        }
        byte[] result = new byte[length];
        System.arraycopy(src, start, result, 0, length);
        return result;
    }

    public static int getIntN(int data, int offset) {
        if ((data & 1 << (offset %= 32)) != 0) {
            return 1;
        }
        return 0;
    }

    public static int setIntN(int data, int offset, int value) {
        offset %= 32;
        if (value == 1) {
            return data | 1 << offset;
        }
        return data & ~(1 << offset);
    }

    public static int getByteN(byte data, int offset) {
        if ((0xFF & data & 1 << 7 - (offset %= 8)) != 0) {
            return 1;
        }
        return 0;
    }

    public static byte setByteN(byte data, int offset, int value) {
        offset %= 8;
        if (value == 1) {
            return (byte)(0xFF & data | 1 << 7 - offset);
        }
        return (byte)(0xFF & data & ~(1 << 7 - offset));
    }

    public static int getLongN(long data, int offset) {
        if ((data & 1L << (offset %= 64)) != 0L) {
            return 1;
        }
        return 0;
    }

    public static long setLongN(long data, int offset, int value) {
        offset %= 64;
        if (value == 1) {
            return data | 1L << offset;
        }
        return data & (1L << offset ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static double readDouble(InputStream in) throws IOException {
        byte[] b = BytesUtils.safeReadInputStreamToBytes(8, in);
        return BytesUtils.bytesToDouble(b);
    }

    public static float readFloat(InputStream in) throws IOException {
        byte[] b = BytesUtils.safeReadInputStreamToBytes(4, in);
        return BytesUtils.bytesToFloat(b);
    }

    public static boolean readBool(InputStream in) throws IOException {
        byte[] b = BytesUtils.safeReadInputStreamToBytes(1, in);
        return BytesUtils.bytesToBool(b);
    }

    public static int readInt(InputStream in) throws IOException {
        byte[] b = BytesUtils.safeReadInputStreamToBytes(4, in);
        return BytesUtils.bytesToInt(b);
    }

    public static long readLong(InputStream in) throws IOException {
        byte[] b = BytesUtils.safeReadInputStreamToBytes(8, in);
        return BytesUtils.bytesToLong(b);
    }

    public static byte[] safeReadInputStreamToBytes(int count, InputStream in) throws IOException {
        byte[] bytes = new byte[count];
        for (int readCount = 0; readCount < count; readCount += in.read(bytes, readCount, count - readCount)) {
        }
        return bytes;
    }

    public static byte[] shortToBytes(short number) {
        int temp = number;
        byte[] b = new byte[2];
        for (int i = b.length - 1; i >= 0; --i) {
            b[i] = (byte)temp;
            temp >>= 8;
        }
        return b;
    }

    public static short bytesToShort(byte[] b) {
        short s0 = (short)(b[1] & 0xFF);
        short s1 = (short)(b[0] & 0xFF);
        s1 = (short)(s1 << 8);
        short s2 = (short)(s0 | s1);
        return s2;
    }

    public static Binary valueOf(String value) {
        return new Binary(BytesUtils.stringToBytes(value));
    }
}

