/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.expression.impl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GlobalTimeExpression
implements IUnaryExpression,
Serializable {
    private static final long serialVersionUID = 1146132942359113670L;
    private Filter filter;

    public GlobalTimeExpression(Filter filter) {
        this.filter = filter;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.GLOBAL_TIME;
    }

    @Override
    public IExpression clone() {
        return new GlobalTimeExpression(this.filter.copy());
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        try {
            ReadWriteIOUtils.write((byte)this.getType().ordinal(), byteBuffer);
            this.filter.serialize(byteBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static GlobalTimeExpression deserialize(ByteBuffer byteBuffer) {
        return new GlobalTimeExpression(Filter.deserialize(byteBuffer));
    }

    public String toString() {
        return "[" + this.filter + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalTimeExpression that = (GlobalTimeExpression)o;
        return Objects.equals(this.toString(), that.toString());
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }
}

