/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import java.util.Arrays;
import java.util.Optional;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoding;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnUtil;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class FloatColumn
implements Column {
    private static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(FloatColumn.class);
    public static final int SIZE_IN_BYTES_PER_POSITION = 5;
    private final int arrayOffset;
    private final int positionCount;
    private final boolean[] valueIsNull;
    private final float[] values;
    private final long retainedSizeInBytes;

    public FloatColumn(int positionCount, Optional<boolean[]> valueIsNull, float[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    FloatColumn(int arrayOffset, int positionCount, boolean[] valueIsNull, float[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + RamUsageEstimator.sizeOfFloatArray(positionCount) + RamUsageEstimator.sizeOfBooleanArray(positionCount);
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.FLOAT;
    }

    @Override
    public ColumnEncoding getEncoding() {
        return ColumnEncoding.INT32_ARRAY;
    }

    @Override
    public float getFloat(int position) {
        return this.values[position + this.arrayOffset];
    }

    @Override
    public float[] getFloats() {
        return this.values;
    }

    @Override
    public Object getObject(int position) {
        return Float.valueOf(this.getFloat(position));
    }

    @Override
    public TsPrimitiveType getTsPrimitiveType(int position) {
        return new TsPrimitiveType.TsFloat(this.getFloat(position));
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean isNull(int position) {
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public boolean[] isNull() {
        if (this.valueIsNull == null) {
            boolean[] res = new boolean[this.positionCount];
            Arrays.fill(res, false);
            return res;
        }
        return this.valueIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new FloatColumn(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Column subColumn(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        return new FloatColumn(this.arrayOffset + fromIndex, this.positionCount - fromIndex, this.valueIsNull, this.values);
    }

    @Override
    public void reverse() {
        int j;
        int i = this.arrayOffset;
        for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
            float valueTmp = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = valueTmp;
        }
        if (this.valueIsNull != null) {
            i = this.arrayOffset;
            for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
                boolean isNullTmp = this.valueIsNull[i];
                this.valueIsNull[i] = this.valueIsNull[j];
                this.valueIsNull[j] = isNullTmp;
            }
        }
    }

    @Override
    public int getInstanceSize() {
        return INSTANCE_SIZE;
    }
}

