/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription;

import java.util.Map;
import java.util.Set;
import org.apache.iotdb.session.subscription.SubscriptionMessage;
import org.apache.iotdb.session.subscription.SubscriptionPullConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullConsumerAutoCommitWorker
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PullConsumerAutoCommitWorker.class);
    private final SubscriptionPullConsumer consumer;

    public PullConsumerAutoCommitWorker(SubscriptionPullConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public void run() {
        if (this.consumer.isClosed()) {
            return;
        }
        long currentTimestamp = System.currentTimeMillis();
        long index = currentTimestamp / this.consumer.getAutoCommitIntervalMs();
        if (currentTimestamp % this.consumer.getAutoCommitIntervalMs() == 0L) {
            --index;
        }
        for (Map.Entry<Long, Set<SubscriptionMessage>> entry : this.consumer.getUncommittedMessages().headMap(index).entrySet()) {
            try {
                this.consumer.commitSync((Iterable<SubscriptionMessage>)entry.getValue());
                this.consumer.getUncommittedMessages().remove(entry.getKey());
            }
            catch (Exception e) {
                LOGGER.warn("something unexpected happened when auto commit messages...", e);
            }
        }
    }
}

