/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription;

import org.apache.iotdb.session.subscription.SubscriptionConsumer;
import org.apache.iotdb.session.subscription.SubscriptionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerHeartbeatWorker
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerHeartbeatWorker.class);
    private final SubscriptionConsumer consumer;

    public ConsumerHeartbeatWorker(SubscriptionConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public void run() {
        if (this.consumer.isClosed()) {
            return;
        }
        this.consumer.acquireWriteLock();
        try {
            this.heartbeatInternal();
        }
        finally {
            this.consumer.releaseWriteLock();
        }
    }

    private void heartbeatInternal() {
        for (SubscriptionProvider provider : this.consumer.getAllProviders()) {
            try {
                provider.getSessionConnection().heartbeat();
                provider.setAvailable();
            }
            catch (Exception e) {
                LOGGER.warn("something unexpected happened when sending heartbeat to subscription provider {}, exception: {}, set subscription provider unavailable", (Object)provider, (Object)e.getMessage());
                provider.setUnavailable();
            }
        }
    }
}

