/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.io.IOException;
import org.apache.iotdb.rpc.TCompressedElasticFramedTransport;
import org.apache.iotdb.rpc.TElasticFramedTransport;
import org.apache.thrift.transport.TTransport;
import org.xerial.snappy.Snappy;

public class TSnappyElasticFramedTransport
extends TCompressedElasticFramedTransport {
    public TSnappyElasticFramedTransport(TTransport underlying) {
        this(underlying, 1024, 0x20000000, true);
    }

    public TSnappyElasticFramedTransport(TTransport underlying, int thriftDefaultBufferSize, int thriftMaxFrameSize, boolean copyBinary) {
        super(underlying, thriftDefaultBufferSize, thriftMaxFrameSize, copyBinary);
    }

    @Override
    protected int uncompressedLength(byte[] buf, int off, int len) throws IOException {
        return Snappy.uncompressedLength(buf, off, len);
    }

    @Override
    protected int maxCompressedLength(int len) {
        return Snappy.maxCompressedLength(len);
    }

    @Override
    protected int compress(byte[] input, int inOff, int len, byte[] output, int outOff) throws IOException {
        return Snappy.compress(input, inOff, len, output, outOff);
    }

    @Override
    protected void uncompress(byte[] input, int inOff, int size, byte[] output, int outOff) throws IOException {
        Snappy.uncompress(input, inOff, size, output, outOff);
    }

    public static class Factory
    extends TElasticFramedTransport.Factory {
        public Factory() {
            this(1024, 0x20000000, true);
        }

        public Factory(int thriftDefaultBufferSize, boolean copyBinary) {
            this(thriftDefaultBufferSize, 0x20000000, copyBinary);
        }

        public Factory(int thriftDefaultBufferSize, int thriftMaxFrameSize, boolean copyBinary) {
            super(thriftDefaultBufferSize, thriftMaxFrameSize, copyBinary);
        }

        @Override
        public TTransport getTransport(TTransport trans) {
            return new TSnappyElasticFramedTransport(trans, this.thriftDefaultBufferSize, this.thriftMaxFrameSize, this.copyBinary);
        }
    }
}

