/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.sql.provider;

import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.types.RowKind;
import org.apache.iotdb.flink.sql.function.IoTDBSinkFunction;
import org.apache.iotdb.flink.sql.wrapper.SchemaWrapper;

public class IoTDBDynamicTableSink
implements DynamicTableSink {
    private final ReadableConfig options;
    private final TableSchema schema;

    public IoTDBDynamicTableSink(ReadableConfig options, TableSchema schema) {
        this.options = options;
        this.schema = schema;
    }

    public ChangelogMode getChangelogMode(ChangelogMode changelogMode) {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.DELETE).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).build();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        return SinkFunctionProvider.of((SinkFunction)new IoTDBSinkFunction(this.options, new SchemaWrapper(this.schema)));
    }

    public DynamicTableSink copy() {
        return new IoTDBDynamicTableSink(this.options, this.schema);
    }

    public String asSummaryString() {
        return "IoTDB Dynamic Table Sink";
    }
}

