/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.sql.function;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.iotdb.flink.sql.common.Options;
import org.apache.iotdb.flink.sql.common.Utils;
import org.apache.iotdb.flink.sql.exception.IllegalSchemaException;
import org.apache.iotdb.flink.sql.wrapper.SchemaWrapper;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.RowRecord;

public class IoTDBBoundedScanFunction
extends RichInputFormat<RowData, InputSplit> {
    private final ReadableConfig options;
    private final String sql;
    private final List<Tuple2<String, DataType>> tableSchema;
    private final long lowerBound;
    private final long upperBound;
    private Session session;
    private SessionDataSet dataSet;
    private List<String> columnNames;

    public IoTDBBoundedScanFunction(ReadableConfig options, SchemaWrapper schemaWrapper) {
        this.options = options;
        this.tableSchema = schemaWrapper.getSchema();
        this.sql = (String)options.get(Options.SQL);
        this.lowerBound = (Long)options.get(Options.SCAN_BOUNDED_LOWER_BOUND);
        this.upperBound = (Long)options.get(Options.SCAN_BOUNDED_UPPER_BOUND);
    }

    public void configure(Configuration configuration) {
    }

    public BaseStatistics getStatistics(BaseStatistics baseStatistics) {
        return baseStatistics;
    }

    public InputSplit[] createInputSplits(int i) {
        return new GenericInputSplit[]{new GenericInputSplit(1, 1)};
    }

    public InputSplitAssigner getInputSplitAssigner(InputSplit[] inputSplits) {
        return new DefaultInputSplitAssigner(inputSplits);
    }

    public void openInputFormat() {
        this.session = new Session.Builder().nodeUrls(Arrays.asList(((String)this.options.get(Options.NODE_URLS)).split(","))).username((String)this.options.get(Options.USER)).password((String)this.options.get(Options.PASSWORD)).build();
        try {
            this.session.open(false);
        }
        catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        }
    }

    public void open(InputSplit inputSplit) {
        String sql = this.lowerBound < 0L && this.upperBound < 0L ? this.sql : (this.lowerBound < 0L && this.upperBound > 0L ? String.format("%s WHERE TIME <= %d", this.sql, this.upperBound) : (this.lowerBound > 0L && this.upperBound < 0L ? String.format("%s WHERE TIME >= %d", this.sql, this.lowerBound) : String.format("%s WHERE TIME >= %d AND TIME <= %d", this.sql, this.lowerBound, this.upperBound)));
        try {
            this.dataSet = this.session.executeQueryStatement(sql);
            this.columnNames = this.dataSet.getColumnNames();
            for (Tuple2<String, DataType> field : this.tableSchema) {
                DataType flinkType;
                if (!this.columnNames.contains(field.f0)) continue;
                int index = this.columnNames.indexOf(field.f0);
                TSDataType iotdbType = TSDataType.valueOf(this.dataSet.getColumnTypes().get(index));
                if (Utils.isTypeEqual(iotdbType, flinkType = (DataType)field.f1)) continue;
                throw new IllegalSchemaException(String.format("The data type of column `%s` is different in IoTDB and Flink", field.f0));
            }
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean reachedEnd() {
        try {
            return !this.dataSet.hasNext();
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public RowData nextRecord(RowData rowData) {
        try {
            RowRecord rowRecord = this.dataSet.next();
            return Utils.convert(rowRecord, this.columnNames, this.tableSchema);
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            if (this.dataSet != null) {
                this.dataSet.close();
            }
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

