/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils.KillPoint;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(KillPoint.class);

    public static String addKillPointPrefix(String name) {
        return "[KILL POINT] " + name;
    }

    public static ImmutableSet<String> parseKillPoints(String s2) {
        if (s2 == null) {
            return ImmutableSet.of();
        }
        Set result = Arrays.stream(s2.replace("[", "").replace("]", "").replace(" ", "").split(",")).collect(Collectors.toSet());
        LOGGER.info("Kill point set: {}", (Object)result);
        return ImmutableSet.copyOf(result);
    }

    public static <T extends Enum<T>> void setKillPoint(T x) {
        if (CommonDescriptor.getInstance().getConfig().isIntegrationTest()) {
            String breakPointName = KillPoint.enumToString(x);
            if (CommonDescriptor.getInstance().getConfig().getEnabledKillPoints().contains(breakPointName)) {
                LOGGER.info(KillPoint.addKillPointPrefix(breakPointName));
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static <T extends Enum<?>> String enumToString(T x) {
        return x.getClass().getSimpleName() + "." + x.name();
    }
}

