/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.exception.UDFParameterNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFM4
implements UDTF {
    protected AccessStrategy accessStrategy;
    protected TSDataType dataType;
    public static final String WINDOW_SIZE_KEY = "windowSize";
    public static final String TIME_INTERVAL_KEY = "timeInterval";
    public static final String SLIDING_STEP_KEY = "slidingStep";
    public static final String DISPLAY_WINDOW_BEGIN_KEY = "displayWindowBegin";
    public static final String DISPLAY_WINDOW_END_KEY = "displayWindowEnd";

    @Override
    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
        if (!validator.getParameters().hasAttribute(WINDOW_SIZE_KEY) && !validator.getParameters().hasAttribute(TIME_INTERVAL_KEY)) {
            throw new UDFParameterNotValidException(String.format("attribute \"%s\"/\"%s\" is required but was not provided.", WINDOW_SIZE_KEY, TIME_INTERVAL_KEY));
        }
        if (validator.getParameters().hasAttribute(WINDOW_SIZE_KEY) && validator.getParameters().hasAttribute(TIME_INTERVAL_KEY)) {
            throw new UDFParameterNotValidException(String.format("use attribute \"%s\" or \"%s\" only one at a time.", WINDOW_SIZE_KEY, TIME_INTERVAL_KEY));
        }
        this.accessStrategy = validator.getParameters().hasAttribute(WINDOW_SIZE_KEY) ? AccessStrategy.SIZE_WINDOW : AccessStrategy.TIME_WINDOW;
        this.dataType = UDFDataTypeTransformer.transformToTsDataType(validator.getParameters().getDataType(0));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws MetadataException {
        configurations.setOutputDataType(UDFDataTypeTransformer.transformToUDFDataType(this.dataType));
        if (this.accessStrategy == AccessStrategy.SIZE_WINDOW) {
            int windowSize = parameters.getInt(WINDOW_SIZE_KEY);
            int slidingStep = parameters.getIntOrDefault(SLIDING_STEP_KEY, windowSize);
            configurations.setAccessStrategy(new SlidingSizeWindowAccessStrategy(windowSize, slidingStep));
        } else {
            long timeInterval = parameters.getLong(TIME_INTERVAL_KEY);
            long displayWindowBegin = parameters.getLongOrDefault(DISPLAY_WINDOW_BEGIN_KEY, Long.MIN_VALUE);
            long displayWindowEnd = parameters.getLongOrDefault(DISPLAY_WINDOW_END_KEY, Long.MAX_VALUE);
            long slidingStep = parameters.getLongOrDefault(SLIDING_STEP_KEY, timeInterval);
            configurations.setAccessStrategy(new SlidingTimeWindowAccessStrategy(timeInterval, slidingStep, displayWindowBegin, displayWindowEnd));
        }
    }

    @Override
    public void transform(RowWindow rowWindow, PointCollector collector) throws UDFException, IOException {
        switch (this.dataType) {
            case INT32: {
                this.transformInt(rowWindow, collector);
                break;
            }
            case INT64: {
                this.transformLong(rowWindow, collector);
                break;
            }
            case FLOAT: {
                this.transformFloat(rowWindow, collector);
                break;
            }
            case DOUBLE: {
                this.transformDouble(rowWindow, collector);
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
            }
        }
    }

    public void transformInt(RowWindow rowWindow, PointCollector collector) throws IOException {
        if (rowWindow.windowSize() > 0) {
            int index;
            int size = rowWindow.windowSize();
            int firstValueIndex = -1;
            int firstValue = 0;
            for (index = 0; index < size; ++index) {
                if (rowWindow.getRow(index).isNull(0)) continue;
                firstValueIndex = index;
                firstValue = rowWindow.getRow(index).getInt(0);
                break;
            }
            if (firstValueIndex != -1) {
                int lastValueIndex = firstValueIndex;
                int lastValue = firstValue;
                int minValueIndex = firstValueIndex;
                int minValue = firstValue;
                int maxValueIndex = firstValueIndex;
                int maxValue = firstValue;
                while (index < size) {
                    if (!rowWindow.getRow(index).isNull(0)) {
                        lastValueIndex = index;
                        lastValue = rowWindow.getRow(index).getInt(0);
                        if (lastValue < minValue) {
                            minValue = lastValue;
                            minValueIndex = index;
                        }
                        if (lastValue > maxValue) {
                            maxValue = lastValue;
                            maxValueIndex = index;
                        }
                    }
                    ++index;
                }
                collector.putInt(rowWindow.getRow(firstValueIndex).getTime(), firstValue);
                int smallerIndex = Math.min(minValueIndex, maxValueIndex);
                int largerIndex = Math.max(minValueIndex, maxValueIndex);
                if (smallerIndex > firstValueIndex && rowWindow.getRow(smallerIndex).getInt(0) != lastValue) {
                    collector.putInt(rowWindow.getRow(smallerIndex).getTime(), rowWindow.getRow(smallerIndex).getInt(0));
                }
                if (largerIndex > smallerIndex && rowWindow.getRow(largerIndex).getInt(0) != lastValue) {
                    collector.putInt(rowWindow.getRow(largerIndex).getTime(), rowWindow.getRow(largerIndex).getInt(0));
                }
                if (lastValueIndex > firstValueIndex) {
                    collector.putInt(rowWindow.getRow(lastValueIndex).getTime(), lastValue);
                }
            }
        }
    }

    public void transformLong(RowWindow rowWindow, PointCollector collector) throws IOException {
        if (rowWindow.windowSize() > 0) {
            int index;
            int size = rowWindow.windowSize();
            int firstValueIndex = -1;
            long firstValue = 0L;
            for (index = 0; index < size; ++index) {
                if (rowWindow.getRow(index).isNull(0)) continue;
                firstValueIndex = index;
                firstValue = rowWindow.getRow(index).getLong(0);
                break;
            }
            if (firstValueIndex != -1) {
                int lastValueIndex = firstValueIndex;
                long lastValue = firstValue;
                int minValueIndex = firstValueIndex;
                long minValue = firstValue;
                int maxValueIndex = firstValueIndex;
                long maxValue = firstValue;
                while (index < size) {
                    if (!rowWindow.getRow(index).isNull(0)) {
                        lastValueIndex = index;
                        lastValue = rowWindow.getRow(index).getLong(0);
                        if (lastValue < minValue) {
                            minValue = lastValue;
                            minValueIndex = index;
                        }
                        if (lastValue > maxValue) {
                            maxValue = lastValue;
                            maxValueIndex = index;
                        }
                    }
                    ++index;
                }
                collector.putLong(rowWindow.getRow(firstValueIndex).getTime(), firstValue);
                int smallerIndex = Math.min(minValueIndex, maxValueIndex);
                int largerIndex = Math.max(minValueIndex, maxValueIndex);
                if (smallerIndex > firstValueIndex && rowWindow.getRow(smallerIndex).getLong(0) != lastValue) {
                    collector.putLong(rowWindow.getRow(smallerIndex).getTime(), rowWindow.getRow(smallerIndex).getLong(0));
                }
                if (largerIndex > smallerIndex && rowWindow.getRow(largerIndex).getLong(0) != lastValue) {
                    collector.putLong(rowWindow.getRow(largerIndex).getTime(), rowWindow.getRow(largerIndex).getLong(0));
                }
                if (lastValueIndex > firstValueIndex) {
                    collector.putLong(rowWindow.getRow(lastValueIndex).getTime(), lastValue);
                }
            }
        }
    }

    public void transformFloat(RowWindow rowWindow, PointCollector collector) throws IOException {
        if (rowWindow.windowSize() > 0) {
            int index;
            int size = rowWindow.windowSize();
            int firstValueIndex = -1;
            float firstValue = 0.0f;
            for (index = 0; index < size; ++index) {
                if (rowWindow.getRow(index).isNull(0)) continue;
                firstValueIndex = index;
                firstValue = rowWindow.getRow(index).getFloat(0);
                break;
            }
            if (firstValueIndex != -1) {
                int lastValueIndex = firstValueIndex;
                float lastValue = firstValue;
                int minValueIndex = firstValueIndex;
                float minValue = firstValue;
                int maxValueIndex = firstValueIndex;
                float maxValue = firstValue;
                while (index < size) {
                    if (!rowWindow.getRow(index).isNull(0)) {
                        lastValueIndex = index;
                        lastValue = rowWindow.getRow(index).getFloat(0);
                        if (lastValue < minValue) {
                            minValue = lastValue;
                            minValueIndex = index;
                        }
                        if (lastValue > maxValue) {
                            maxValue = lastValue;
                            maxValueIndex = index;
                        }
                    }
                    ++index;
                }
                collector.putFloat(rowWindow.getRow(firstValueIndex).getTime(), firstValue);
                int smallerIndex = Math.min(minValueIndex, maxValueIndex);
                int largerIndex = Math.max(minValueIndex, maxValueIndex);
                if (smallerIndex > firstValueIndex && rowWindow.getRow(smallerIndex).getFloat(0) != lastValue) {
                    collector.putFloat(rowWindow.getRow(smallerIndex).getTime(), rowWindow.getRow(smallerIndex).getFloat(0));
                }
                if (largerIndex > smallerIndex && rowWindow.getRow(largerIndex).getFloat(0) != lastValue) {
                    collector.putFloat(rowWindow.getRow(largerIndex).getTime(), rowWindow.getRow(largerIndex).getFloat(0));
                }
                if (lastValueIndex > firstValueIndex) {
                    collector.putFloat(rowWindow.getRow(lastValueIndex).getTime(), lastValue);
                }
            }
        }
    }

    public void transformDouble(RowWindow rowWindow, PointCollector collector) throws IOException {
        if (rowWindow.windowSize() > 0) {
            int index;
            int size = rowWindow.windowSize();
            int firstValueIndex = -1;
            double firstValue = 0.0;
            for (index = 0; index < size; ++index) {
                if (rowWindow.getRow(index).isNull(0)) continue;
                firstValueIndex = index;
                firstValue = rowWindow.getRow(index).getDouble(0);
                break;
            }
            if (firstValueIndex != -1) {
                int lastValueIndex = firstValueIndex;
                double lastValue = firstValue;
                int minValueIndex = firstValueIndex;
                double minValue = firstValue;
                int maxValueIndex = firstValueIndex;
                double maxValue = firstValue;
                while (index < size) {
                    if (!rowWindow.getRow(index).isNull(0)) {
                        lastValueIndex = index;
                        lastValue = rowWindow.getRow(index).getDouble(0);
                        if (lastValue < minValue) {
                            minValue = lastValue;
                            minValueIndex = index;
                        }
                        if (lastValue > maxValue) {
                            maxValue = lastValue;
                            maxValueIndex = index;
                        }
                    }
                    ++index;
                }
                collector.putDouble(rowWindow.getRow(firstValueIndex).getTime(), firstValue);
                int smallerIndex = Math.min(minValueIndex, maxValueIndex);
                int largerIndex = Math.max(minValueIndex, maxValueIndex);
                if (smallerIndex > firstValueIndex && rowWindow.getRow(smallerIndex).getDouble(0) != lastValue) {
                    collector.putDouble(rowWindow.getRow(smallerIndex).getTime(), rowWindow.getRow(smallerIndex).getDouble(0));
                }
                if (largerIndex > smallerIndex && rowWindow.getRow(largerIndex).getDouble(0) != lastValue) {
                    collector.putDouble(rowWindow.getRow(largerIndex).getTime(), rowWindow.getRow(largerIndex).getDouble(0));
                }
                if (lastValueIndex > firstValueIndex) {
                    collector.putDouble(rowWindow.getRow(lastValueIndex).getTime(), lastValue);
                }
            }
        }
    }

    static enum AccessStrategy {
        SIZE_WINDOW,
        TIME_WINDOW;

    }
}

