/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.commons.udf.builtin.BuiltinTimeSeriesGeneratingFunction;
import org.apache.iotdb.commons.udf.service.UDFClassLoader;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class UDFTable {
    private final Map<String, UDFInformation> udfInformationMap = new ConcurrentHashMap<String, UDFInformation>();
    private final Map<String, Class<?>> functionToClassMap = new ConcurrentHashMap();

    public UDFTable() {
        this.registerBuiltinTimeSeriesGeneratingFunctions();
    }

    private void registerBuiltinTimeSeriesGeneratingFunctions() {
        for (BuiltinTimeSeriesGeneratingFunction builtinTimeSeriesGeneratingFunction : BuiltinTimeSeriesGeneratingFunction.values()) {
            String functionName = builtinTimeSeriesGeneratingFunction.getFunctionName();
            this.udfInformationMap.put(functionName, new UDFInformation(functionName.toUpperCase(), builtinTimeSeriesGeneratingFunction.getClassName(), true, false));
            this.functionToClassMap.put(functionName.toUpperCase(), builtinTimeSeriesGeneratingFunction.getFunctionClass());
        }
    }

    public void addUDFInformation(String functionName, UDFInformation udfInformation) {
        this.udfInformationMap.put(functionName.toUpperCase(), udfInformation);
    }

    public void removeUDFInformation(String functionName) {
        this.udfInformationMap.remove(functionName.toUpperCase());
    }

    public UDFInformation getUDFInformation(String functionName) {
        return this.udfInformationMap.get(functionName.toUpperCase());
    }

    public void addFunctionAndClass(String functionName, Class<?> clazz) {
        this.functionToClassMap.put(functionName.toUpperCase(), clazz);
    }

    public Class<?> getFunctionClass(String functionName) {
        return this.functionToClassMap.get(functionName.toUpperCase());
    }

    public void removeFunctionClass(String functionName) {
        this.functionToClassMap.remove(functionName.toUpperCase());
    }

    public void updateFunctionClass(UDFInformation udfInformation, UDFClassLoader classLoader) throws ClassNotFoundException {
        Class<?> functionClass = Class.forName(udfInformation.getClassName(), true, classLoader);
        this.functionToClassMap.put(udfInformation.getFunctionName().toUpperCase(), functionClass);
    }

    public UDFInformation[] getAllUDFInformation() {
        return this.udfInformationMap.values().toArray(new UDFInformation[0]);
    }

    public List<UDFInformation> getAllNonBuiltInUDFInformation() {
        return this.udfInformationMap.values().stream().filter(udfInformation -> !udfInformation.isBuiltin()).collect(Collectors.toList());
    }

    public boolean containsUDF(String udfName) {
        return this.udfInformationMap.containsKey(udfName);
    }

    public Map<String, UDFInformation> getTable() {
        return this.udfInformationMap;
    }

    public void serializeUDFTable(OutputStream outputStream) throws IOException {
        List<UDFInformation> nonBuiltInUDFInformation = this.getAllNonBuiltInUDFInformation();
        ReadWriteIOUtils.write(nonBuiltInUDFInformation.size(), outputStream);
        for (UDFInformation udfInformation : nonBuiltInUDFInformation) {
            ReadWriteIOUtils.write(udfInformation.serialize(), outputStream);
        }
    }

    public void deserializeUDFTable(InputStream inputStream) throws IOException {
        for (int size = ReadWriteIOUtils.readInt(inputStream); size > 0; --size) {
            UDFInformation udfInformation = UDFInformation.deserialize(inputStream);
            this.udfInformationMap.put(udfInformation.getFunctionName(), udfInformation);
        }
    }

    public void clear() {
        this.udfInformationMap.forEach((K2, V) -> {
            if (!V.isBuiltin()) {
                this.udfInformationMap.remove(K2);
            }
        });
    }
}

