/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.meta.subscription;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SubscriptionMeta {
    private String topicName;
    private String consumerGroupId;
    private Set<String> consumerIds;

    private SubscriptionMeta() {
    }

    public SubscriptionMeta(String topicName, String consumerGroupId, Set<String> consumerIds) {
        this.topicName = topicName;
        this.consumerGroupId = consumerGroupId;
        this.consumerIds = consumerIds;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public Set<String> getConsumerIds() {
        return this.consumerIds;
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(DataOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write(this.topicName, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.consumerGroupId, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.consumerIds.size(), (OutputStream)outputStream);
        for (String consumerId : this.consumerIds) {
            ReadWriteIOUtils.write(consumerId, (OutputStream)outputStream);
        }
    }

    public void serialize(FileOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write(this.topicName, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.consumerGroupId, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.consumerIds.size(), (OutputStream)outputStream);
        for (String consumerId : this.consumerIds) {
            ReadWriteIOUtils.write(consumerId, (OutputStream)outputStream);
        }
    }

    public static SubscriptionMeta deserialize(InputStream inputStream) throws IOException {
        SubscriptionMeta subscriptionMeta = new SubscriptionMeta();
        subscriptionMeta.topicName = ReadWriteIOUtils.readString(inputStream);
        subscriptionMeta.consumerGroupId = ReadWriteIOUtils.readString(inputStream);
        subscriptionMeta.consumerIds = new HashSet<String>();
        int size = ReadWriteIOUtils.readInt(inputStream);
        for (int i = 0; i < size; ++i) {
            subscriptionMeta.consumerIds.add(ReadWriteIOUtils.readString(inputStream));
        }
        return subscriptionMeta;
    }

    public static SubscriptionMeta deserialize(ByteBuffer byteBuffer) {
        SubscriptionMeta subscriptionMeta = new SubscriptionMeta();
        subscriptionMeta.topicName = ReadWriteIOUtils.readString(byteBuffer);
        subscriptionMeta.consumerGroupId = ReadWriteIOUtils.readString(byteBuffer);
        subscriptionMeta.consumerIds = new HashSet<String>();
        int size = ReadWriteIOUtils.readInt(byteBuffer);
        for (int i = 0; i < size; ++i) {
            subscriptionMeta.consumerIds.add(ReadWriteIOUtils.readString(byteBuffer));
        }
        return subscriptionMeta;
    }
}

