/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.meta.consumer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.rpc.subscription.config.ConsumerConfig;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ConsumerMeta {
    private String consumerId;
    private long creationTime;
    private ConsumerConfig config;

    private ConsumerMeta() {
    }

    public ConsumerMeta(String consumerId, long creationTime, Map<String, String> consumerAttributes) {
        this.consumerId = consumerId;
        this.creationTime = creationTime;
        this.config = new ConsumerConfig(consumerAttributes);
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write(this.consumerId, outputStream);
        ReadWriteIOUtils.write(this.creationTime, outputStream);
        ReadWriteIOUtils.write(this.config.getAttribute().size(), outputStream);
        for (Map.Entry<String, String> entry : this.config.getAttribute().entrySet()) {
            ReadWriteIOUtils.write(entry.getKey(), outputStream);
            ReadWriteIOUtils.write(entry.getValue(), outputStream);
        }
    }

    public static ConsumerMeta deserialize(InputStream inputStream) throws IOException {
        ConsumerMeta consumerMeta = new ConsumerMeta();
        consumerMeta.consumerId = ReadWriteIOUtils.readString(inputStream);
        consumerMeta.creationTime = ReadWriteIOUtils.readLong(inputStream);
        consumerMeta.config = new ConsumerConfig(new HashMap<String, String>());
        int size = ReadWriteIOUtils.readInt(inputStream);
        for (int i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString(inputStream);
            String value = ReadWriteIOUtils.readString(inputStream);
            consumerMeta.config.getAttribute().put(key, value);
        }
        return consumerMeta;
    }

    public static ConsumerMeta deserialize(ByteBuffer byteBuffer) {
        ConsumerMeta consumerMeta = new ConsumerMeta();
        consumerMeta.consumerId = ReadWriteIOUtils.readString(byteBuffer);
        consumerMeta.creationTime = ReadWriteIOUtils.readLong(byteBuffer);
        consumerMeta.config = new ConsumerConfig(new HashMap<String, String>());
        int size = ReadWriteIOUtils.readInt(byteBuffer);
        for (int i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString(byteBuffer);
            String value = ReadWriteIOUtils.readString(byteBuffer);
            consumerMeta.config.getAttribute().put(key, value);
        }
        return consumerMeta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConsumerMeta that = (ConsumerMeta)obj;
        return Objects.equals(this.consumerId, that.consumerId) && Objects.equals(this.creationTime, that.creationTime) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.consumerId, this.creationTime, this.config);
    }

    public String toString() {
        return "ConsumerMeta{consumerID='" + this.consumerId + "', creationTime=" + this.creationTime + ", config=" + this.config + "}";
    }
}

