/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.config;

import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionConfig {
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionConfig.class);

    public int getSubscriptionSubtaskExecutorMaxThreadNum() {
        return COMMON_CONFIG.getSubscriptionSubtaskExecutorMaxThreadNum();
    }

    public int getSubscriptionMaxTabletsPerPrefetching() {
        return COMMON_CONFIG.getSubscriptionMaxTabletsPerPrefetching();
    }

    public int getSubscriptionPollMaxBlockingTimeMs() {
        return COMMON_CONFIG.getSubscriptionPollMaxBlockingTimeMs();
    }

    public int getSubscriptionSerializeMaxBlockingTimeMs() {
        return COMMON_CONFIG.getSubscriptionSerializeMaxBlockingTimeMs();
    }

    public long getSubscriptionLaunchRetryIntervalMs() {
        return COMMON_CONFIG.getSubscriptionLaunchRetryIntervalMs();
    }

    public int getSubscriptionRecycleUncommittedEventIntervalMs() {
        return COMMON_CONFIG.getSubscriptionRecycleUncommittedEventIntervalMs();
    }

    public long getSubscriptionDefaultPollTimeoutMs() {
        return COMMON_CONFIG.getSubscriptionDefaultPollTimeoutMs();
    }

    public long getSubscriptionMinPollTimeoutMs() {
        return COMMON_CONFIG.getSubscriptionMinPollTimeoutMs();
    }

    public void printAllConfigs() {
        LOGGER.info("SubscriptionSubtaskExecutorMaxThreadNum: {}", (Object)this.getSubscriptionSubtaskExecutorMaxThreadNum());
        LOGGER.info("SubscriptionMaxTabletsPerPrefetching: {}", (Object)this.getSubscriptionMaxTabletsPerPrefetching());
        LOGGER.info("SubscriptionPollMaxBlockingTimeMs: {}", (Object)this.getSubscriptionPollMaxBlockingTimeMs());
        LOGGER.info("SubscriptionSerializeMaxBlockingTimeMs: {}", (Object)this.getSubscriptionSerializeMaxBlockingTimeMs());
        LOGGER.info("SubscriptionLaunchRetryIntervalMs: {}", (Object)this.getSubscriptionLaunchRetryIntervalMs());
        LOGGER.info("SubscriptionRecycleUncommittedEventIntervalMs: {}", (Object)this.getSubscriptionRecycleUncommittedEventIntervalMs());
        LOGGER.info("SubscriptionDefaultPollTimeoutMs: {}", (Object)this.getSubscriptionDefaultPollTimeoutMs());
        LOGGER.info("SubscriptionMinPollTimeoutMs: {}", (Object)this.getSubscriptionMinPollTimeoutMs());
    }

    private SubscriptionConfig() {
    }

    public static SubscriptionConfig getInstance() {
        return SubscriptionConfigHolder.INSTANCE;
    }

    private static class SubscriptionConfigHolder {
        private static final SubscriptionConfig INSTANCE = new SubscriptionConfig();

        private SubscriptionConfigHolder() {
        }
    }
}

