/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.task.meta;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public enum PipeRuntimeMetaVersion {
    VERSION_1(PipeStatus.RUNNING.getType()),
    VERSION_2(127);

    private static final Map<Byte, PipeRuntimeMetaVersion> VERSION_MAP;
    private final byte version;

    private PipeRuntimeMetaVersion(byte version) {
        this.version = version;
    }

    public byte getVersion() {
        return this.version;
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write(this.version, outputStream);
    }

    public static PipeRuntimeMetaVersion deserialize(InputStream inputStream) throws IOException {
        return PipeRuntimeMetaVersion.deserialize(ReadWriteIOUtils.readByte(inputStream));
    }

    public static PipeRuntimeMetaVersion deserialize(ByteBuffer byteBuffer) {
        return PipeRuntimeMetaVersion.deserialize(ReadWriteIOUtils.readByte(byteBuffer));
    }

    public static PipeRuntimeMetaVersion deserialize(byte version) {
        return VERSION_MAP.get(version);
    }

    static {
        VERSION_MAP = new HashMap<Byte, PipeRuntimeMetaVersion>();
        for (PipeStatus pipeStatus : PipeStatus.values()) {
            VERSION_MAP.put(pipeStatus.getType(), VERSION_1);
        }
        for (Enum enum_ : PipeRuntimeMetaVersion.values()) {
            VERSION_MAP.put(((PipeRuntimeMetaVersion)enum_).getVersion(), (PipeRuntimeMetaVersion)enum_);
        }
    }
}

