/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.receiver;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.pipe.receiver.IoTDBReceiver;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBReceiverAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBReceiverAgent.class);
    protected static final Map<Byte, Supplier<IoTDBReceiver>> RECEIVER_CONSTRUCTORS = new HashMap<Byte, Supplier<IoTDBReceiver>>();

    protected abstract void initConstructors();

    protected IoTDBReceiverAgent() {
        this.initConstructors();
    }

    public final TPipeTransferResp receive(TPipeTransferReq req) {
        return this.receive(null, req);
    }

    public final TPipeTransferResp receive(String key, TPipeTransferReq req) {
        byte reqVersion = req.getVersion();
        if (RECEIVER_CONSTRUCTORS.containsKey(reqVersion)) {
            return this.getReceiver(key, reqVersion).receive(req);
        }
        return new TPipeTransferResp(RpcUtils.getStatus(TSStatusCode.PIPE_VERSION_ERROR, String.format("Unsupported pipe version %d", reqVersion)));
    }

    protected final IoTDBReceiver getReceiver(String key, byte reqVersion) {
        if (this.getReceiverWithSpecifiedClient(key) == null) {
            return this.setAndGetReceiver(key, reqVersion);
        }
        byte receiverThreadLocalVersion = this.getReceiverWithSpecifiedClient(key).getVersion().getVersion();
        if (receiverThreadLocalVersion != reqVersion) {
            LOGGER.warn("The receiver version {} is different from the sender version {}, the receiver will be reset to the sender version.", (Object)receiverThreadLocalVersion, (Object)reqVersion);
            this.getReceiverWithSpecifiedClient(key).handleExit();
            this.removeReceiverWithSpecifiedClient(key);
            return this.setAndGetReceiver(key, reqVersion);
        }
        return this.getReceiverWithSpecifiedClient(key);
    }

    private IoTDBReceiver setAndGetReceiver(String key, byte reqVersion) {
        if (!RECEIVER_CONSTRUCTORS.containsKey(reqVersion)) {
            throw new UnsupportedOperationException(String.format("Unsupported pipe version %d", reqVersion));
        }
        this.setReceiverWithSpecifiedClient(key, RECEIVER_CONSTRUCTORS.get(reqVersion).get());
        return this.getReceiverWithSpecifiedClient(key);
    }

    protected abstract IoTDBReceiver getReceiverWithSpecifiedClient(String var1);

    protected abstract void setReceiverWithSpecifiedClient(String var1, IoTDBReceiver var2);

    protected abstract void removeReceiverWithSpecifiedClient(String var1);

    public final void handleClientExit() {
        this.handleClientExit(null);
    }

    public final void handleClientExit(String key) {
        IoTDBReceiver receiver = this.getReceiverWithSpecifiedClient(key);
        if (receiver != null) {
            receiver.handleExit();
            this.removeReceiverWithSpecifiedClient(key);
        }
    }

    public static void cleanPipeReceiverDir(File receiverFileDir) {
        try {
            FileUtils.deleteDirectory(receiverFileDir);
            LOGGER.info("Clean pipe receiver dir {} successfully.", (Object)receiverFileDir);
        }
        catch (Exception e) {
            LOGGER.warn("Clean pipe receiver dir {} failed.", (Object)receiverFileDir, (Object)e);
        }
        try {
            FileUtils.forceMkdir(receiverFileDir);
            LOGGER.info("Create pipe receiver dir {} successfully.", (Object)receiverFileDir);
        }
        catch (IOException e) {
            LOGGER.warn("Create pipe receiver dir {} failed.", (Object)receiverFileDir, (Object)e);
        }
    }
}

