/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.metric;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.pipe.progress.PipeEventCommitter;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeEventCommitMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeEventCommitMetrics.class);
    private volatile AbstractMetricService metricService;
    private final Map<String, PipeEventCommitter> eventCommitterMap = new ConcurrentHashMap<String, PipeEventCommitter>();

    @Override
    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet<String> committerKeys = ImmutableSet.copyOf(this.eventCommitterMap.keySet());
        for (String committerKey : committerKeys) {
            this.createMetrics(committerKey);
        }
    }

    private void createMetrics(String committerKey) {
        this.createAutoGauge(committerKey);
    }

    private void createAutoGauge(String committerKey) {
        PipeEventCommitter eventCommitter = this.eventCommitterMap.get(committerKey);
        this.metricService.createAutoGauge(Metric.PIPE_EVENT_COMMIT_QUEUE_SIZE.toString(), MetricLevel.IMPORTANT, eventCommitter, PipeEventCommitter::commitQueueSize, Tag.NAME.toString(), String.valueOf(eventCommitter.getPipeName()), Tag.REGION.toString(), String.valueOf(eventCommitter.getDataRegionId()));
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet<String> committerKeys = ImmutableSet.copyOf(this.eventCommitterMap.keySet());
        for (String committerKey : committerKeys) {
            this.deregister(committerKey);
        }
        if (!this.eventCommitterMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe event commit metrics, event committer map not empty");
        }
    }

    private void removeMetrics(String committerKey) {
        this.removeAutoGauge(committerKey);
    }

    private void removeAutoGauge(String committerKey) {
        PipeEventCommitter eventCommitter = this.eventCommitterMap.get(committerKey);
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_EVENT_COMMIT_QUEUE_SIZE.toString(), Tag.NAME.toString(), String.valueOf(eventCommitter.getPipeName()), Tag.REGION.toString(), String.valueOf(eventCommitter.getDataRegionId()));
    }

    public void register(PipeEventCommitter eventCommitter, String committerKey) {
        if (Objects.isNull(eventCommitter)) {
            return;
        }
        this.eventCommitterMap.putIfAbsent(committerKey, eventCommitter);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(committerKey);
        }
    }

    public void deregister(String committerKey) {
        if (!this.eventCommitterMap.containsKey(committerKey)) {
            LOGGER.warn("Failed to deregister pipe event commit metrics, PipeEventCommitter({}) does not exist", (Object)committerKey);
            return;
        }
        if (Objects.nonNull(committerKey)) {
            this.removeMetrics(committerKey);
        }
        this.eventCommitterMap.remove(committerKey);
    }

    public static PipeEventCommitMetrics getInstance() {
        return PipeEventCommitMetricsHolder.INSTANCE;
    }

    private PipeEventCommitMetrics() {
    }

    private static class PipeEventCommitMetricsHolder {
        private static final PipeEventCommitMetrics INSTANCE = new PipeEventCommitMetrics();

        private PipeEventCommitMetricsHolder() {
        }
    }
}

