/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.extractor;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MetaProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.datastructure.queue.ConcurrentIterableLinkedQueue;
import org.apache.iotdb.commons.pipe.datastructure.queue.listening.AbstractPipeListeningQueue;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.PipeSnapshotEvent;
import org.apache.iotdb.commons.pipe.extractor.IoTDBExtractor;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.tsfile.utils.Pair;

public abstract class IoTDBNonDataRegionExtractor
extends IoTDBExtractor {
    private List<PipeSnapshotEvent> historicalEvents = new LinkedList<PipeSnapshotEvent>();
    private ConcurrentIterableLinkedQueue.DynamicIterator iterator;
    protected final AtomicBoolean hasBeenClosed = new AtomicBoolean(false);

    protected abstract AbstractPipeListeningQueue getListeningQueue();

    @Override
    public void start() throws Exception {
        if (this.hasBeenStarted.get() || this.hasBeenClosed.get()) {
            return;
        }
        super.start();
        ProgressIndex progressIndex = this.pipeTaskMeta.getProgressIndex();
        long nextIndex = progressIndex instanceof MinimumProgressIndex || !this.getListeningQueue().isGivenNextIndexValid(((MetaProgressIndex)progressIndex).getIndex() + 1L) ? this.getNextIndexAfterSnapshot() : ((MetaProgressIndex)progressIndex).getIndex() + 1L;
        this.iterator = this.getListeningQueue().newIterator(nextIndex);
    }

    private long getNextIndexAfterSnapshot() {
        long nextIndex;
        if (this.needTransferSnapshot()) {
            nextIndex = this.findSnapshot();
            if (nextIndex == Long.MIN_VALUE) {
                this.triggerSnapshot();
                nextIndex = this.findSnapshot();
                if (nextIndex == Long.MIN_VALUE) {
                    throw new PipeException("Cannot get the newest snapshot after triggering one.");
                }
            }
        } else {
            nextIndex = Long.MAX_VALUE;
        }
        return nextIndex;
    }

    private long findSnapshot() {
        Pair<Long, List<PipeSnapshotEvent>> queueTailIndex2Snapshots = this.getListeningQueue().findAvailableSnapshots();
        long nextIndex = Objects.nonNull(queueTailIndex2Snapshots.getLeft()) && queueTailIndex2Snapshots.getLeft() != Long.MIN_VALUE ? queueTailIndex2Snapshots.getLeft() : Long.MIN_VALUE;
        this.historicalEvents = new LinkedList<PipeSnapshotEvent>((Collection)queueTailIndex2Snapshots.getRight());
        return nextIndex;
    }

    protected abstract boolean needTransferSnapshot();

    protected abstract void triggerSnapshot();

    @Override
    public EnrichedEvent supply() throws Exception {
        EnrichedEvent realtimeEvent;
        if (this.hasBeenClosed.get()) {
            return null;
        }
        if (!this.hasBeenStarted.get()) {
            this.start();
        }
        if (!this.historicalEvents.isEmpty()) {
            PipeSnapshotEvent historicalEvent = (PipeSnapshotEvent)this.historicalEvents.remove(0).shallowCopySelfAndBindPipeTaskMetaForProgressReport(this.pipeName, this.pipeTaskMeta, null, Long.MIN_VALUE, Long.MAX_VALUE);
            if (this.historicalEvents.isEmpty()) {
                historicalEvent.bindProgressIndex(new MetaProgressIndex(this.iterator.getNextIndex() - 1L));
            }
            historicalEvent.increaseReferenceCount(IoTDBNonDataRegionExtractor.class.getName());
            this.confineHistoricalEventTransferTypes(historicalEvent);
            return historicalEvent;
        }
        do {
            if (!Objects.isNull(realtimeEvent = (EnrichedEvent)this.iterator.next(this.getMaxBlockingTimeMs()))) continue;
            return null;
        } while (!this.isTypeListened(realtimeEvent) || !this.isForwardingPipeRequests && realtimeEvent.isGeneratedByPipe());
        realtimeEvent = realtimeEvent.shallowCopySelfAndBindPipeTaskMetaForProgressReport(this.pipeName, this.pipeTaskMeta, null, Long.MIN_VALUE, Long.MAX_VALUE);
        realtimeEvent.bindProgressIndex(new MetaProgressIndex(this.iterator.getNextIndex() - 1L));
        realtimeEvent.increaseReferenceCount(IoTDBNonDataRegionExtractor.class.getName());
        return realtimeEvent;
    }

    protected abstract long getMaxBlockingTimeMs();

    protected abstract boolean isTypeListened(Event var1);

    protected abstract void confineHistoricalEventTransferTypes(PipeSnapshotEvent var1);

    @Override
    public void close() throws Exception {
        if (this.hasBeenClosed.get()) {
            return;
        }
        this.hasBeenClosed.set(true);
        if (!this.hasBeenStarted.get()) {
            return;
        }
        this.getListeningQueue().returnIterator(this.iterator);
        this.historicalEvents.clear();
    }
}

