/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.payload.thrift.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.IoTDBConnectorRequestVersion;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class PipeTransferFileSealReqV2
extends TPipeTransferReq {
    private transient List<String> fileNames;
    private transient List<Long> fileLengths;
    private transient Map<String, String> parameters;

    public final List<String> getFileNames() {
        return this.fileNames;
    }

    public final List<Long> getFileLengths() {
        return this.fileLengths;
    }

    public final Map<String, String> getParameters() {
        return this.parameters;
    }

    protected abstract PipeRequestType getPlanType();

    protected PipeTransferFileSealReqV2 convertToTPipeTransferReq(List<String> fileNames, List<Long> fileLengths, Map<String, String> parameters) throws IOException {
        this.fileNames = fileNames;
        this.fileLengths = fileLengths;
        this.parameters = parameters;
        this.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        this.type = this.getPlanType().getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);){
            ReadWriteIOUtils.write(fileNames.size(), (OutputStream)outputStream);
            for (String string : fileNames) {
                ReadWriteIOUtils.write(string, (OutputStream)outputStream);
            }
            ReadWriteIOUtils.write(fileLengths.size(), (OutputStream)outputStream);
            for (Long l : fileLengths) {
                ReadWriteIOUtils.write((long)l, (OutputStream)outputStream);
            }
            ReadWriteIOUtils.write(parameters.size(), (OutputStream)outputStream);
            for (Map.Entry entry : parameters.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((String)entry.getValue(), (OutputStream)outputStream);
            }
            this.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return this;
    }

    public PipeTransferFileSealReqV2 translateFromTPipeTransferReq(TPipeTransferReq req) {
        int i;
        this.fileNames = new ArrayList<String>();
        int size = ReadWriteIOUtils.readInt(req.body);
        for (i = 0; i < size; ++i) {
            this.fileNames.add(ReadWriteIOUtils.readString(req.body));
        }
        this.fileLengths = new ArrayList<Long>();
        size = ReadWriteIOUtils.readInt(req.body);
        for (i = 0; i < size; ++i) {
            this.fileLengths.add(ReadWriteIOUtils.readLong(req.body));
        }
        this.parameters = new HashMap<String, String>();
        size = ReadWriteIOUtils.readInt(req.body);
        for (i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString(req.body);
            String value = ReadWriteIOUtils.readString(req.body);
            this.parameters.put(key, value);
        }
        this.version = req.version;
        this.type = req.type;
        this.body = req.body;
        return this;
    }

    public byte[] convertToTPipeTransferSnapshotSealBytes(List<String> fileNames, List<Long> fileLengths, Map<String, String> parameters) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            Object object;
            try (DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);){
                ReadWriteIOUtils.write(IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write(this.getPlanType().getType(), (OutputStream)outputStream);
                ReadWriteIOUtils.write(fileNames.size(), (OutputStream)outputStream);
                for (String string : fileNames) {
                    ReadWriteIOUtils.write(string, (OutputStream)outputStream);
                }
                ReadWriteIOUtils.write(fileLengths.size(), (OutputStream)outputStream);
                for (Long l : fileLengths) {
                    ReadWriteIOUtils.write((long)l, (OutputStream)outputStream);
                }
                ReadWriteIOUtils.write(parameters.size(), (OutputStream)outputStream);
                for (Map.Entry entry : parameters.entrySet()) {
                    ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                    ReadWriteIOUtils.write((String)entry.getValue(), (OutputStream)outputStream);
                }
                object = byteArrayOutputStream.toByteArray();
            }
            return object;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferFileSealReqV2 that = (PipeTransferFileSealReqV2)obj;
        return Objects.equals(this.fileNames, that.fileNames) && Objects.equals(this.fileLengths, that.fileLengths) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.version, that.version) && Objects.equals(this.type, that.type) && Objects.equals(this.body, that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fileNames, this.fileLengths, this.parameters, this.version, this.type, this.body);
    }
}

