/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBClientManager;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBSyncClient;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferHandshakeV1Req;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferHandshakeV2Req;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBSyncClientManager
extends IoTDBClientManager
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBSyncClientManager.class);
    private static final PipeConfig PIPE_CONFIG = PipeConfig.getInstance();
    private final boolean useSSL;
    private final String trustStorePath;
    private final String trustStorePwd;
    protected final Map<TEndPoint, Pair<IoTDBSyncClient, Boolean>> endPoint2ClientAndStatus = new ConcurrentHashMap<TEndPoint, Pair<IoTDBSyncClient, Boolean>>();
    private final LoadBalancer loadBalancer;

    protected IoTDBSyncClientManager(List<TEndPoint> endPoints, boolean useSSL, String trustStorePath, String trustStorePwd, boolean useLeaderCache, String loadBalanceStrategy) {
        super(endPoints, useLeaderCache);
        this.useSSL = useSSL;
        this.trustStorePath = trustStorePath;
        this.trustStorePwd = trustStorePwd;
        for (TEndPoint endPoint : endPoints) {
            this.endPoint2ClientAndStatus.put(endPoint, new Pair<Object, Boolean>(null, false));
        }
        switch (loadBalanceStrategy) {
            case "round-robin": {
                this.loadBalancer = new RoundRobinLoadBalancer();
                break;
            }
            case "random": {
                this.loadBalancer = new RandomLoadBalancer();
                break;
            }
            case "priority": {
                this.loadBalancer = new PriorityLoadBalancer();
                break;
            }
            default: {
                LOGGER.warn("Unknown load balance strategy: {}, use round-robin strategy instead.", (Object)loadBalanceStrategy);
                this.loadBalancer = new RoundRobinLoadBalancer();
            }
        }
    }

    public void checkClientStatusAndTryReconstructIfNecessary() {
        for (Map.Entry<TEndPoint, Pair<IoTDBSyncClient, Boolean>> entry : this.endPoint2ClientAndStatus.entrySet()) {
            if (Boolean.TRUE.equals(entry.getValue().getRight())) continue;
            this.reconstructClient(entry.getKey());
        }
        for (Pair pair : this.endPoint2ClientAndStatus.values()) {
            if (!Boolean.TRUE.equals(pair.getRight())) continue;
            return;
        }
        throw new PipeConnectionException(String.format("All target servers %s are not available.", this.endPoint2ClientAndStatus.keySet()));
    }

    protected void reconstructClient(TEndPoint endPoint) {
        Pair<IoTDBSyncClient, Boolean> clientAndStatus = this.endPoint2ClientAndStatus.get(endPoint);
        if (clientAndStatus.getLeft() != null) {
            try {
                clientAndStatus.getLeft().close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close client with target server ip: {}, port: {}, because: {}. Ignore it.", endPoint.getIp(), endPoint.getPort(), e.getMessage());
            }
        }
        this.initClientAndStatus(clientAndStatus, endPoint);
        this.sendHandshakeReq(clientAndStatus);
    }

    private void initClientAndStatus(Pair<IoTDBSyncClient, Boolean> clientAndStatus, TEndPoint endPoint) {
        try {
            clientAndStatus.setLeft(new IoTDBSyncClient(new ThriftClientProperty.Builder().setConnectionTimeoutMs(PIPE_CONFIG.getPipeConnectorHandshakeTimeoutMs()).setRpcThriftCompressionEnabled(PIPE_CONFIG.isPipeConnectorRPCThriftCompressionEnabled()).build(), endPoint.getIp(), endPoint.getPort(), this.useSSL, this.trustStorePath, this.trustStorePwd));
        }
        catch (Exception e) {
            throw new PipeConnectionException(String.format("Error occurred while connecting to receiver %s:%s, please check network connectivity or SSL configurations when enable SSL transmission", endPoint.getIp(), endPoint.getPort()), e);
        }
    }

    public void sendHandshakeReq(Pair<IoTDBSyncClient, Boolean> clientAndStatus) {
        IoTDBSyncClient client = clientAndStatus.getLeft();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("timestampPrecision", CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
            params.put("clusterID", this.getClusterId());
            TPipeTransferResp resp = client.pipeTransfer(this.buildHandshakeV2Req(params));
            if (resp.getStatus().getCode() == TSStatusCode.PIPE_TYPE_ERROR.getStatusCode()) {
                LOGGER.info("Handshake error with target server ip: {}, port: {}, because: {}. Retry to handshake by PipeTransferHandshakeV1Req.", client.getIpAddress(), client.getPort(), resp.getStatus());
                this.supportModsIfIsDataNodeReceiver = false;
                resp = client.pipeTransfer(this.buildHandshakeV1Req());
            }
            if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.warn("Handshake error with target server ip: {}, port: {}, because: {}.", client.getIpAddress(), client.getPort(), resp.getStatus());
            } else {
                clientAndStatus.setRight(true);
                client.setTimeout(CONNECTION_TIMEOUT_MS.get());
                LOGGER.info("Handshake success. Target server ip: {}, port: {}", (Object)client.getIpAddress(), (Object)client.getPort());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Handshake error with target server ip: {}, port: {}, because: {}.", client.getIpAddress(), client.getPort(), e.getMessage(), e);
        }
    }

    protected abstract PipeTransferHandshakeV1Req buildHandshakeV1Req() throws IOException;

    protected abstract PipeTransferHandshakeV2Req buildHandshakeV2Req(Map<String, String> var1) throws IOException;

    protected abstract String getClusterId();

    public Pair<IoTDBSyncClient, Boolean> getClient() {
        return this.loadBalancer.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        for (Map.Entry<TEndPoint, Pair<IoTDBSyncClient, Boolean>> entry : this.endPoint2ClientAndStatus.entrySet()) {
            TEndPoint endPoint = entry.getKey();
            Pair<IoTDBSyncClient, Boolean> clientAndStatus = entry.getValue();
            if (clientAndStatus == null) continue;
            try {
                if (clientAndStatus.getLeft() != null) {
                    clientAndStatus.getLeft().close();
                    clientAndStatus.setLeft(null);
                }
                LOGGER.info("Client {}:{} closed.", (Object)endPoint.getIp(), (Object)endPoint.getPort());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close client {}:{}, because: {}.", endPoint.getIp(), endPoint.getPort(), e.getMessage(), e);
            }
            finally {
                clientAndStatus.setRight(false);
            }
        }
    }

    private class PriorityLoadBalancer
    implements LoadBalancer {
        private PriorityLoadBalancer() {
        }

        @Override
        public Pair<IoTDBSyncClient, Boolean> getClient() {
            for (TEndPoint endPoint : IoTDBSyncClientManager.this.endPointList) {
                Pair<IoTDBSyncClient, Boolean> clientAndStatus = IoTDBSyncClientManager.this.endPoint2ClientAndStatus.get(endPoint);
                if (!Boolean.TRUE.equals(clientAndStatus.getRight())) continue;
                return clientAndStatus;
            }
            throw new PipeConnectionException("All clients are dead, please check the connection to the receiver.");
        }
    }

    private class RandomLoadBalancer
    implements LoadBalancer {
        private RandomLoadBalancer() {
        }

        @Override
        public Pair<IoTDBSyncClient, Boolean> getClient() {
            int clientSize = IoTDBSyncClientManager.this.endPointList.size();
            int clientIndex = (int)(Math.random() * (double)clientSize);
            Pair<IoTDBSyncClient, Boolean> clientAndStatus = IoTDBSyncClientManager.this.endPoint2ClientAndStatus.get(IoTDBSyncClientManager.this.endPointList.get(clientIndex));
            if (Boolean.TRUE.equals(clientAndStatus.getRight())) {
                return clientAndStatus;
            }
            for (int tryCount = 0; tryCount < clientSize - 1; ++tryCount) {
                int nextClientIndex = (clientIndex + tryCount + 1) % clientSize;
                Pair<IoTDBSyncClient, Boolean> nextClientAndStatus = IoTDBSyncClientManager.this.endPoint2ClientAndStatus.get(IoTDBSyncClientManager.this.endPointList.get(nextClientIndex));
                if (!Boolean.TRUE.equals(nextClientAndStatus.getRight())) continue;
                return nextClientAndStatus;
            }
            throw new PipeConnectionException("All clients are dead, please check the connection to the receiver.");
        }
    }

    private class RoundRobinLoadBalancer
    implements LoadBalancer {
        private RoundRobinLoadBalancer() {
        }

        @Override
        public Pair<IoTDBSyncClient, Boolean> getClient() {
            int clientSize = IoTDBSyncClientManager.this.endPointList.size();
            for (int tryCount = 0; tryCount < clientSize; ++tryCount) {
                int clientIndex;
                Pair<IoTDBSyncClient, Boolean> clientAndStatus;
                if (!Boolean.TRUE.equals((clientAndStatus = IoTDBSyncClientManager.this.endPoint2ClientAndStatus.get(IoTDBSyncClientManager.this.endPointList.get(clientIndex = (int)(IoTDBSyncClientManager.this.currentClientIndex++ % (long)clientSize)))).getRight())) continue;
                return clientAndStatus;
            }
            throw new PipeConnectionException("All clients are dead, please check the connection to the receiver.");
        }
    }

    private static interface LoadBalancer {
        public Pair<IoTDBSyncClient, Boolean> getClient();
    }
}

