/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TimeWindowStateProgressIndex
extends ProgressIndex {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<String, Pair<Long, ByteBuffer>> timeSeries2TimestampWindowBufferPairMap;

    public TimeWindowStateProgressIndex(@Nonnull Map<String, Pair<Long, ByteBuffer>> timeSeries2TimestampWindowBufferPairMap) {
        this.timeSeries2TimestampWindowBufferPairMap = timeSeries2TimestampWindowBufferPairMap;
    }

    private TimeWindowStateProgressIndex() {
    }

    public Map<String, Pair<Long, ByteBuffer>> getTimeSeries2TimestampWindowBufferPairMap() {
        return this.timeSeries2TimestampWindowBufferPairMap;
    }

    public long getMinTime() {
        return this.timeSeries2TimestampWindowBufferPairMap.values().stream().mapToLong(Pair::getLeft).min().orElse(Long.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.TIME_WINDOW_STATE_PROGRESS_INDEX.serialize(byteBuffer);
            ReadWriteIOUtils.write(this.timeSeries2TimestampWindowBufferPairMap.size(), byteBuffer);
            for (Map.Entry<String, Pair<Long, ByteBuffer>> entry : this.timeSeries2TimestampWindowBufferPairMap.entrySet()) {
                ReadWriteIOUtils.write(entry.getKey(), byteBuffer);
                ReadWriteIOUtils.write((long)entry.getValue().getLeft(), byteBuffer);
                ByteBuffer buffer = entry.getValue().getRight();
                if (Objects.nonNull(buffer)) {
                    ReadWriteIOUtils.write(buffer.limit(), byteBuffer);
                    byteBuffer.put(buffer.array(), 0, buffer.limit());
                    continue;
                }
                ReadWriteIOUtils.write(-1, byteBuffer);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream stream) throws IOException {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.TIME_WINDOW_STATE_PROGRESS_INDEX.serialize(stream);
            ReadWriteIOUtils.write(this.timeSeries2TimestampWindowBufferPairMap.size(), stream);
            for (Map.Entry<String, Pair<Long, ByteBuffer>> entry : this.timeSeries2TimestampWindowBufferPairMap.entrySet()) {
                ReadWriteIOUtils.write(entry.getKey(), stream);
                ReadWriteIOUtils.write((long)entry.getValue().getLeft(), stream);
                ByteBuffer buffer = entry.getValue().getRight();
                if (Objects.nonNull(buffer)) {
                    ReadWriteIOUtils.write(buffer.limit(), stream);
                    stream.write(buffer.array(), 0, buffer.limit());
                    continue;
                }
                ReadWriteIOUtils.write(-1, stream);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfter(@Nonnull ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (progressIndex instanceof MinimumProgressIndex) {
                boolean bl = true;
                return bl;
            }
            if (progressIndex instanceof HybridProgressIndex) {
                boolean bl = ((HybridProgressIndex)progressIndex).isGivenProgressIndexAfterSelf(this);
                return bl;
            }
            if (!(progressIndex instanceof TimeWindowStateProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            TimeWindowStateProgressIndex thisTimeWindowStateProgressIndex = this;
            TimeWindowStateProgressIndex thatTimeWindowStateProgressIndex = (TimeWindowStateProgressIndex)progressIndex;
            boolean bl = thatTimeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap.entrySet().stream().noneMatch(entry -> !thisTimeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap.containsKey(entry.getKey()) || thisTimeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap.get(entry.getKey()).getLeft() <= (Long)((Pair)entry.getValue()).getLeft());
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (!(progressIndex instanceof TimeWindowStateProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            TimeWindowStateProgressIndex thisTimeWindowStateProgressIndex = this;
            TimeWindowStateProgressIndex thatTimeWindowStateProgressIndex = (TimeWindowStateProgressIndex)progressIndex;
            boolean bl = thisTimeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap.equals(thatTimeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeWindowStateProgressIndex)) {
            return false;
        }
        return this.equals((TimeWindowStateProgressIndex)obj);
    }

    public int hashCode() {
        return Objects.hash(this.timeSeries2TimestampWindowBufferPairMap);
    }

    @Override
    public ProgressIndex updateToMinimumEqualOrIsAfterProgressIndex(ProgressIndex progressIndex) {
        this.lock.writeLock().lock();
        try {
            if (!(progressIndex instanceof TimeWindowStateProgressIndex)) {
                TimeWindowStateProgressIndex timeWindowStateProgressIndex = this;
                return timeWindowStateProgressIndex;
            }
            this.timeSeries2TimestampWindowBufferPairMap.putAll(((TimeWindowStateProgressIndex)progressIndex).timeSeries2TimestampWindowBufferPairMap.entrySet().stream().filter(entry -> !this.timeSeries2TimestampWindowBufferPairMap.containsKey(entry.getKey()) || this.timeSeries2TimestampWindowBufferPairMap.get(entry.getKey()).getLeft() <= (Long)((Pair)entry.getValue()).getLeft()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            TimeWindowStateProgressIndex timeWindowStateProgressIndex = this;
            return timeWindowStateProgressIndex;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ProgressIndexType getType() {
        return ProgressIndexType.TIME_WINDOW_STATE_PROGRESS_INDEX;
    }

    @Override
    public ProgressIndex.TotalOrderSumTuple getTotalOrderSumTuple() {
        throw new UnsupportedOperationException("TimeWindowStateProgressIndex does not support topological sorting");
    }

    public static TimeWindowStateProgressIndex deserializeFrom(ByteBuffer byteBuffer) {
        TimeWindowStateProgressIndex timeWindowStateProgressIndex = new TimeWindowStateProgressIndex();
        timeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap = new HashMap<String, Pair<Long, ByteBuffer>>();
        int size = ReadWriteIOUtils.readInt(byteBuffer);
        for (int i = 0; i < size; ++i) {
            String timeSeries = ReadWriteIOUtils.readString(byteBuffer);
            long timestamp = ReadWriteIOUtils.readLong(byteBuffer);
            int length = ReadWriteIOUtils.readInt(byteBuffer);
            if (length < 0) continue;
            byte[] body = new byte[length];
            byteBuffer.get(body);
            ByteBuffer dstBuffer = ByteBuffer.wrap(body);
            timeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap.put(timeSeries, new Pair<Long, ByteBuffer>(timestamp, dstBuffer));
        }
        return timeWindowStateProgressIndex;
    }

    public static TimeWindowStateProgressIndex deserializeFrom(InputStream stream) throws IOException {
        TimeWindowStateProgressIndex timeWindowStateProgressIndex = new TimeWindowStateProgressIndex();
        timeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap = new HashMap<String, Pair<Long, ByteBuffer>>();
        int size = ReadWriteIOUtils.readInt(stream);
        for (int i = 0; i < size; ++i) {
            String timeSeries = ReadWriteIOUtils.readString(stream);
            long timestamp = ReadWriteIOUtils.readLong(stream);
            int length = ReadWriteIOUtils.readInt(stream);
            if (length < 0) continue;
            byte[] body = new byte[length];
            int readLen = stream.read(body);
            if (readLen != length) {
                throw new IOException(String.format("The intended read length is %s but %s is actually read when deserializing TimeProgressIndex, ProgressIndex: %s", length, readLen, timeWindowStateProgressIndex));
            }
            ByteBuffer dstBuffer = ByteBuffer.wrap(body);
            timeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap.put(timeSeries, new Pair<Long, ByteBuffer>(timestamp, dstBuffer));
        }
        return timeWindowStateProgressIndex;
    }

    public String toString() {
        return "TimeWindowStateProgressIndex{timeSeries2TimeWindowBufferPairMap='" + this.timeSeries2TimestampWindowBufferPairMap + "'}";
    }
}

