/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class StateProgressIndex
extends ProgressIndex {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private long version;
    private Map<String, Binary> state;
    private ProgressIndex innerProgressIndex;

    public StateProgressIndex(long version, Map<String, Binary> state, ProgressIndex innerProgressIndex) {
        this.version = version;
        this.state = state;
        this.innerProgressIndex = innerProgressIndex;
    }

    public long getVersion() {
        return this.version;
    }

    public ProgressIndex getInnerProgressIndex() {
        return this.innerProgressIndex == null ? MinimumProgressIndex.INSTANCE : this.innerProgressIndex;
    }

    public Map<String, Binary> getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.STATE_PROGRESS_INDEX.serialize(byteBuffer);
            ReadWriteIOUtils.write(this.version, byteBuffer);
            ReadWriteIOUtils.write(this.state.size(), byteBuffer);
            for (Map.Entry<String, Binary> entry : this.state.entrySet()) {
                ReadWriteIOUtils.write(entry.getKey(), byteBuffer);
                ReadWriteIOUtils.write(entry.getValue(), byteBuffer);
            }
            this.innerProgressIndex.serialize(byteBuffer);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream stream) throws IOException {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.STATE_PROGRESS_INDEX.serialize(stream);
            ReadWriteIOUtils.write(this.version, stream);
            ReadWriteIOUtils.write(this.state.size(), stream);
            for (Map.Entry<String, Binary> entry : this.state.entrySet()) {
                ReadWriteIOUtils.write(entry.getKey(), stream);
                ReadWriteIOUtils.write(entry.getValue(), stream);
            }
            this.innerProgressIndex.serialize(stream);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isAfter(@Nonnull ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (progressIndex instanceof MinimumProgressIndex) {
                boolean bl = this.innerProgressIndex.isAfter(progressIndex);
                return bl;
            }
            if (progressIndex instanceof HybridProgressIndex) {
                boolean bl = ((HybridProgressIndex)progressIndex).isGivenProgressIndexAfterSelf(this.innerProgressIndex);
                return bl;
            }
            if (!(progressIndex instanceof StateProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.innerProgressIndex.isAfter(((StateProgressIndex)progressIndex).innerProgressIndex) && this.version > ((StateProgressIndex)progressIndex).version;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            boolean bl = progressIndex instanceof StateProgressIndex && this.innerProgressIndex.equals(((StateProgressIndex)progressIndex).innerProgressIndex) && this.version == ((StateProgressIndex)progressIndex).version;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StateProgressIndex)) {
            return false;
        }
        return this.equals((StateProgressIndex)obj);
    }

    public int hashCode() {
        return Objects.hash(this.innerProgressIndex, this.version);
    }

    @Override
    public ProgressIndex updateToMinimumEqualOrIsAfterProgressIndex(ProgressIndex progressIndex) {
        this.lock.writeLock().lock();
        try {
            this.innerProgressIndex = this.innerProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex(progressIndex instanceof StateProgressIndex ? ((StateProgressIndex)progressIndex).innerProgressIndex : progressIndex);
            if (progressIndex instanceof StateProgressIndex && this.version <= ((StateProgressIndex)progressIndex).version) {
                this.version = ((StateProgressIndex)progressIndex).version;
                this.state = ((StateProgressIndex)progressIndex).state;
            }
            StateProgressIndex stateProgressIndex = this;
            return stateProgressIndex;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ProgressIndexType getType() {
        return ProgressIndexType.STATE_PROGRESS_INDEX;
    }

    @Override
    public ProgressIndex.TotalOrderSumTuple getTotalOrderSumTuple() {
        return this.innerProgressIndex.getTotalOrderSumTuple();
    }

    public static StateProgressIndex deserializeFrom(ByteBuffer byteBuffer) {
        long version = ReadWriteIOUtils.readLong(byteBuffer);
        HashMap<String, Binary> state = new HashMap<String, Binary>();
        int size = ReadWriteIOUtils.readInt(byteBuffer);
        for (int i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString(byteBuffer);
            Binary value = ReadWriteIOUtils.readBinary(byteBuffer);
            state.put(key, value);
        }
        ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(byteBuffer);
        return new StateProgressIndex(version, state, progressIndex);
    }

    public static StateProgressIndex deserializeFrom(InputStream stream) throws IOException {
        long version = ReadWriteIOUtils.readLong(stream);
        HashMap<String, Binary> state = new HashMap<String, Binary>();
        int size = ReadWriteIOUtils.readInt(stream);
        for (int i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString(stream);
            Binary value = ReadWriteIOUtils.readBinary(stream);
            state.put(key, value);
        }
        ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(stream);
        return new StateProgressIndex(version, state, progressIndex);
    }

    public String toString() {
        return "StateProgressIndex{version=" + this.version + ", state=" + this.state + ", innerProgressIndex=" + this.innerProgressIndex + '}';
    }
}

