/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.sync;

import java.net.SocketException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.factory.ThriftClientFactory;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.client.sync.SyncThriftClientWithErrorHandler;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.rpc.DeepCopyRpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.rpc.TimeoutChangeableTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;

public class SyncConfigNodeIServiceClient
extends IConfigNodeRPCService.Client
implements ThriftClient,
AutoCloseable {
    private final boolean printLogWhenEncounterException;
    private final TEndPoint endpoint;
    private final ClientManager<TEndPoint, SyncConfigNodeIServiceClient> clientManager;

    public SyncConfigNodeIServiceClient(ThriftClientProperty property, TEndPoint endPoint, ClientManager<TEndPoint, SyncConfigNodeIServiceClient> clientManager) throws TTransportException {
        super(property.getProtocolFactory().getProtocol(DeepCopyRpcTransportFactory.INSTANCE.getTransport(new TSocket(TConfigurationConst.defaultTConfiguration, endPoint.getIp(), endPoint.getPort(), property.getConnectionTimeoutMs()))));
        this.printLogWhenEncounterException = property.isPrintLogWhenEncounterException();
        this.endpoint = endPoint;
        this.clientManager = clientManager;
        this.getInputProtocol().getTransport().open();
    }

    public int getTimeout() throws SocketException {
        return ((TimeoutChangeableTransport)((Object)this.getInputProtocol().getTransport())).getTimeOut();
    }

    public void setTimeout(int timeout) {
        ((TimeoutChangeableTransport)((Object)this.getInputProtocol().getTransport())).setTimeout(timeout);
    }

    @Override
    public void close() {
        this.clientManager.returnClient(this.endpoint, this);
    }

    @Override
    public void invalidate() {
        this.getInputProtocol().getTransport().close();
    }

    @Override
    public void invalidateAll() {
        this.clientManager.clear(this.endpoint);
    }

    @Override
    public boolean printLogWhenEncounterException() {
        return this.printLogWhenEncounterException;
    }

    public String toString() {
        return String.format("SyncConfigNodeIServiceClient{%s}", this.endpoint);
    }

    public static class Factory
    extends ThriftClientFactory<TEndPoint, SyncConfigNodeIServiceClient> {
        public Factory(ClientManager<TEndPoint, SyncConfigNodeIServiceClient> clientManager, ThriftClientProperty thriftClientProperty) {
            super(clientManager, thriftClientProperty);
        }

        @Override
        public void destroyObject(TEndPoint endpoint, PooledObject<SyncConfigNodeIServiceClient> pooledObject) {
            pooledObject.getObject().invalidate();
        }

        @Override
        public PooledObject<SyncConfigNodeIServiceClient> makeObject(TEndPoint endpoint) throws Exception {
            return new DefaultPooledObject<SyncConfigNodeIServiceClient>(SyncThriftClientWithErrorHandler.newErrorHandler(SyncConfigNodeIServiceClient.class, SyncConfigNodeIServiceClient.class.getConstructor(this.thriftClientProperty.getClass(), endpoint.getClass(), this.clientManager.getClass()), this.thriftClientProperty, endpoint, this.clientManager));
        }

        @Override
        public boolean validateObject(TEndPoint endpoint, PooledObject<SyncConfigNodeIServiceClient> pooledObject) {
            return pooledObject.getObject().getInputProtocol().getTransport().isOpen();
        }
    }
}

