/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.AbstractSessionMessageQueue;
import io.moquette.broker.MemoryQueueRepository;
import io.moquette.broker.SessionRegistry;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class InMemoryQueue
extends AbstractSessionMessageQueue<SessionRegistry.EnqueuedMessage> {
    private final MemoryQueueRepository queueRepository;
    private final String queueName;
    private Queue<SessionRegistry.EnqueuedMessage> queue = new ConcurrentLinkedQueue<SessionRegistry.EnqueuedMessage>();

    public InMemoryQueue() {
        this(null, null);
    }

    public InMemoryQueue(MemoryQueueRepository queueRepository, String queueName) {
        this.queueRepository = queueRepository;
        this.queueName = queueName;
    }

    @Override
    public void enqueue(SessionRegistry.EnqueuedMessage message) {
        this.checkEnqueuePreconditions(message);
        this.queue.add(message);
    }

    @Override
    public SessionRegistry.EnqueuedMessage dequeue() {
        this.checkDequeuePreconditions();
        return this.queue.poll();
    }

    @Override
    public boolean isEmpty() {
        this.checkIsEmptyPreconditions();
        return this.queue.isEmpty();
    }

    @Override
    public void closeAndPurge() {
        for (SessionRegistry.EnqueuedMessage msg : this.queue) {
            msg.release();
        }
        if (this.queueRepository != null) {
            this.queueRepository.dropQueue(this.queueName);
        }
        this.closed = true;
    }
}

