/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.meta.consumer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.rpc.subscription.config.ConsumerConfig;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ConsumerMeta {
    private String consumerId;
    private long creationTime;
    private ConsumerConfig config;

    private ConsumerMeta() {
    }

    public ConsumerMeta(String consumerId, long creationTime, Map<String, String> consumerAttributes) {
        this.consumerId = consumerId;
        this.creationTime = creationTime;
        this.config = new ConsumerConfig(consumerAttributes);
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.consumerId, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.creationTime, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.config.getAttribute().size(), (OutputStream)outputStream);
        for (Map.Entry entry : this.config.getAttribute().entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)outputStream);
        }
    }

    public static ConsumerMeta deserialize(InputStream inputStream) throws IOException {
        ConsumerMeta consumerMeta = new ConsumerMeta();
        consumerMeta.consumerId = ReadWriteIOUtils.readString((InputStream)inputStream);
        consumerMeta.creationTime = ReadWriteIOUtils.readLong((InputStream)inputStream);
        consumerMeta.config = new ConsumerConfig(new HashMap());
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString((InputStream)inputStream);
            String value = ReadWriteIOUtils.readString((InputStream)inputStream);
            consumerMeta.config.getAttribute().put(key, value);
        }
        return consumerMeta;
    }

    public static ConsumerMeta deserialize(ByteBuffer byteBuffer) {
        ConsumerMeta consumerMeta = new ConsumerMeta();
        consumerMeta.consumerId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        consumerMeta.creationTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        consumerMeta.config = new ConsumerConfig(new HashMap());
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            String value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            consumerMeta.config.getAttribute().put(key, value);
        }
        return consumerMeta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConsumerMeta that = (ConsumerMeta)obj;
        return Objects.equals(this.consumerId, that.consumerId) && Objects.equals(this.creationTime, that.creationTime) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.consumerId, this.creationTime, this.config);
    }

    public String toString() {
        return "ConsumerMeta{consumerID='" + this.consumerId + "', creationTime=" + this.creationTime + ", config=" + this.config + "}";
    }
}

