/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.event;

import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.SerializableEvent;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeWritePlanEvent
extends EnrichedEvent
implements SerializableEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeWritePlanEvent.class);
    protected boolean isGeneratedByPipe;
    protected ProgressIndex progressIndex;

    protected PipeWritePlanEvent(String pipeName, PipeTaskMeta pipeTaskMeta, PipePattern pattern, boolean isGeneratedByPipe) {
        super(pipeName, pipeTaskMeta, pattern, Long.MIN_VALUE, Long.MAX_VALUE);
        this.isGeneratedByPipe = isGeneratedByPipe;
    }

    @Override
    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        return true;
    }

    @Override
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        return true;
    }

    @Override
    public void bindProgressIndex(ProgressIndex progressIndex) {
        this.progressIndex = progressIndex;
    }

    @Override
    public ProgressIndex getProgressIndex() {
        return this.progressIndex;
    }

    @Override
    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    @Override
    public boolean mayEventTimeOverlappedWithTimeRange() {
        return true;
    }

    @Override
    public String toString() {
        return String.format("PipeWritePlanEvent{progressIndex=%s, isGeneratedByPipe=%s}", this.progressIndex, this.isGeneratedByPipe) + " - " + super.toString();
    }

    @Override
    public String coreReportMessage() {
        return String.format("PipeWritePlanEvent{progressIndex=%s, isGeneratedByPipe=%s}", this.progressIndex, this.isGeneratedByPipe) + " - " + super.coreReportMessage();
    }
}

