/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.jdbc.Config;
import org.apache.iotdb.jdbc.Constant;
import org.apache.iotdb.jdbc.IoTDBConnectionParams;
import org.apache.iotdb.jdbc.IoTDBURLException;

public class Utils {
    static final Pattern SUFFIX_URL_PATTERN = Pattern.compile("([0-9]{1,5})(/|\\\\?.*=.*(&.*=.*)*)?");
    static final String COLON = ":";
    static final String SLASH = "/";
    static final String PARAMETER_SEPARATOR = "?";
    static final String RPC_COMPRESS = "rpc_compress";

    static IoTDBConnectionParams parseUrl(String url, Properties info) throws IoTDBURLException {
        IoTDBConnectionParams params = new IoTDBConnectionParams(url);
        if (url.trim().equalsIgnoreCase("jdbc:iotdb://")) {
            return params;
        }
        boolean isUrlLegal = false;
        Matcher matcher = null;
        String host = null;
        String suffixURL = null;
        if (url.startsWith("jdbc:iotdb://")) {
            String subURL = url.substring("jdbc:iotdb://".length());
            int i = subURL.lastIndexOf(COLON);
            host = subURL.substring(0, i);
            suffixURL = subURL.substring(i + 1);
            matcher = SUFFIX_URL_PATTERN.matcher(suffixURL);
            if (matcher.matches() && Utils.parseUrlParam(subURL, info)) {
                isUrlLegal = true;
            }
        }
        if (!isUrlLegal) {
            throw new IoTDBURLException("Error url format, url should be jdbc:iotdb://anything:port/ or jdbc:iotdb://anything:port?property1=value1&property2=value2");
        }
        params.setHost(host);
        String port = suffixURL;
        if (suffixURL.contains(PARAMETER_SEPARATOR)) {
            port = suffixURL.split("\\?")[0];
        } else if (suffixURL.contains(SLASH)) {
            port = suffixURL.substring(0, suffixURL.length() - 1);
        }
        params.setPort(Integer.parseInt(port));
        if (info.containsKey("user")) {
            params.setUsername(info.getProperty("user"));
        }
        if (info.containsKey("password")) {
            params.setPassword(info.getProperty("password"));
        }
        if (info.containsKey("thrift_default_buffer_capacity")) {
            params.setThriftDefaultBufferSize(Integer.parseInt(info.getProperty("thrift_default_buffer_capacity")));
        }
        if (info.containsKey("thrift_max_frame_size")) {
            params.setThriftMaxFrameSize(Integer.parseInt(info.getProperty("thrift_max_frame_size")));
        }
        if (info.containsKey("version")) {
            params.setVersion(Constant.Version.valueOf(info.getProperty("version")));
        }
        if (info.containsKey("network_timeout")) {
            params.setNetworkTimeout(Integer.parseInt(info.getProperty("network_timeout")));
        }
        if (info.containsKey("time_zone")) {
            params.setTimeZone(info.getProperty("time_zone"));
        }
        if (info.containsKey("use_ssl")) {
            params.setUseSSL(Boolean.parseBoolean(info.getProperty("use_ssl")));
        }
        if (info.containsKey("trust_store")) {
            params.setTrustStore(info.getProperty("trust_store"));
        }
        if (info.containsKey("trust_store_pwd")) {
            params.setTrustStorePwd(info.getProperty("trust_store_pwd"));
        }
        return params;
    }

    private static boolean parseUrlParam(String subURL, Properties info) {
        String[] params;
        if (!subURL.contains(PARAMETER_SEPARATOR)) {
            return true;
        }
        String paramURL = subURL.substring(subURL.indexOf(63) + 1);
        block16: for (String tmpParam : params = paramURL.split("&")) {
            String[] paramSplit = tmpParam.split("=");
            if (paramSplit.length != 2) {
                return false;
            }
            String key = tmpParam.split("=")[0];
            String value = tmpParam.split("=")[1];
            switch (key) {
                case "rpc_compress": {
                    if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                        Config.rpcThriftCompressionEnable = Boolean.parseBoolean(value);
                        continue block16;
                    }
                    return false;
                }
                case "use_ssl": 
                case "trust_store": 
                case "trust_store_pwd": 
                case "version": 
                case "network_timeout": {
                    info.put(key, value);
                    continue block16;
                }
                case "time_zone": {
                    try {
                        ZoneId.of(value);
                    }
                    catch (DateTimeException e) {
                        return false;
                    }
                    info.put(key, value);
                    continue block16;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private Utils() {
    }
}

