/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.broker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.event.UserDefinedEnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.subscription.broker.SerializedEnrichedEvent;
import org.apache.iotdb.db.subscription.broker.SubscriptionBroker;
import org.apache.iotdb.db.subscription.timer.SubscriptionPollTimer;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.rpc.subscription.payload.EnrichedTablets;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPrefetchingQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionBroker.class);
    private final String brokerId;
    private final String topicName;
    private final BoundedBlockingPendingQueue<Event> inputPendingQueue;
    private final Map<String, SerializedEnrichedEvent> uncommittedEvents;
    private final LinkedBlockingQueue<SerializedEnrichedEvent> prefetchingQueue;
    private final AtomicLong subscriptionCommitIdGenerator = new AtomicLong(0L);

    public SubscriptionPrefetchingQueue(String brokerId, String topicName, BoundedBlockingPendingQueue<Event> inputPendingQueue) {
        this.brokerId = brokerId;
        this.topicName = topicName;
        this.inputPendingQueue = inputPendingQueue;
        this.uncommittedEvents = new ConcurrentHashMap<String, SerializedEnrichedEvent>();
        this.prefetchingQueue = new LinkedBlockingQueue();
    }

    public SerializedEnrichedEvent poll(SubscriptionPollTimer timer) {
        if (this.prefetchingQueue.isEmpty()) {
            this.prefetchOnce(SubscriptionConfig.getInstance().getSubscriptionMaxTabletsPerPrefetching());
        }
        try {
            SerializedEnrichedEvent currentEvent;
            while (Objects.nonNull(currentEvent = this.prefetchingQueue.poll(SubscriptionConfig.getInstance().getSubscriptionPollMaxBlockingTimeMs(), TimeUnit.MILLISECONDS))) {
                if (currentEvent.isCommitted()) continue;
                this.prefetchingQueue.add(currentEvent);
                timer.update();
                if (timer.isExpired()) break;
                if (!currentEvent.pollable()) continue;
                currentEvent.recordLastPolledTimestamp();
                return currentEvent;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Subscription: Interrupted while polling events.", (Throwable)e);
        }
        return null;
    }

    public void commit(List<String> subscriptionCommitIds) {
        for (String subscriptionCommitId : subscriptionCommitIds) {
            SerializedEnrichedEvent event = this.uncommittedEvents.get(subscriptionCommitId);
            if (Objects.isNull(event)) {
                LOGGER.warn("Subscription: subscription commit id [{}] does not exist, it may have been committed or something unexpected happened", (Object)subscriptionCommitId);
                continue;
            }
            event.decreaseReferenceCount();
            event.recordCommittedTimestamp();
            this.uncommittedEvents.remove(subscriptionCommitId);
        }
    }

    public void executePrefetch() {
        this.prefetchOnce(SubscriptionConfig.getInstance().getSubscriptionMaxTabletsPerPrefetching());
        this.serializeOnce();
    }

    private void prefetchOnce(long limit) {
        Event event;
        ArrayList<Tablet> tablets = new ArrayList<Tablet>();
        ArrayList<EnrichedEvent> enrichedEvents = new ArrayList<EnrichedEvent>();
        while (Objects.nonNull(event = UserDefinedEnrichedEvent.maybeOf(this.inputPendingQueue.waitedPoll()))) {
            if (!(event instanceof EnrichedEvent)) {
                LOGGER.warn("Subscription: Only support prefetch EnrichedEvent. Ignore {}.", (Object)event);
                continue;
            }
            if (event instanceof TabletInsertionEvent) {
                List<Tablet> tabletList = this.convertToTablets((TabletInsertionEvent)event);
                if (Objects.isNull(tabletList) || tabletList.isEmpty()) continue;
                tablets.addAll(tabletList);
                enrichedEvents.add((EnrichedEvent)event);
                if ((long)tablets.size() < limit) continue;
                break;
            }
            if (event instanceof PipeTsFileInsertionEvent) {
                for (TabletInsertionEvent tabletInsertionEvent : ((PipeTsFileInsertionEvent)event).toTabletInsertionEvents()) {
                    List<Tablet> tabletList = this.convertToTablets(tabletInsertionEvent);
                    if (Objects.isNull(tabletList) || tabletList.isEmpty()) continue;
                    tablets.addAll(tabletList);
                }
                enrichedEvents.add((EnrichedEvent)event);
                if ((long)tablets.size() < limit) continue;
                break;
            }
            LOGGER.warn("Subscription: Ignore EnrichedEvent {} when prefetching.", (Object)event);
        }
        if (!tablets.isEmpty()) {
            String subscriptionCommitId = this.generateSubscriptionCommitId();
            SerializedEnrichedEvent enrichedEvent = new SerializedEnrichedEvent(new EnrichedTablets(this.topicName, tablets, subscriptionCommitId), enrichedEvents);
            this.uncommittedEvents.put(subscriptionCommitId, enrichedEvent);
            this.prefetchingQueue.add(enrichedEvent);
        }
    }

    private void serializeOnce() {
        long size = this.prefetchingQueue.size();
        long count = 0L;
        try {
            SerializedEnrichedEvent currentEvent;
            while (Objects.nonNull(currentEvent = this.prefetchingQueue.poll(SubscriptionConfig.getInstance().getSubscriptionSerializeMaxBlockingTimeMs(), TimeUnit.MILLISECONDS))) {
                if (currentEvent.isCommitted()) continue;
                this.prefetchingQueue.add(currentEvent);
                if (count < size) {
                    ++count;
                    if (!currentEvent.pollable()) continue;
                    currentEvent.serialize();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Subscription: Interrupted while serializing events.", (Throwable)e);
        }
    }

    private List<Tablet> convertToTablets(TabletInsertionEvent tabletInsertionEvent) {
        if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            return ((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent).convertToTablets();
        }
        if (tabletInsertionEvent instanceof PipeRawTabletInsertionEvent) {
            return Collections.singletonList(((PipeRawTabletInsertionEvent)tabletInsertionEvent).convertToTablet());
        }
        LOGGER.warn("Subscription: Only support convert PipeInsertNodeTabletInsertionEvent or PipeRawTabletInsertionEvent to tablet. Ignore {}.", (Object)tabletInsertionEvent);
        return Collections.emptyList();
    }

    private String generateSubscriptionCommitId() {
        return IoTDBDescriptor.getInstance().getConfig().getDataNodeId() + "#" + PipeAgent.runtime().getRebootTimes() + "#" + this.topicName + "_" + this.brokerId + "#" + this.subscriptionCommitIdGenerator.getAndIncrement();
    }
}

