/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile;

import org.apache.iotdb.tsfile.utils.FilePathUtils;

public class TsFileID {
    public final int regionId;
    public final long timePartitionId;
    public final long fileVersion;
    public final long compactionVersion;

    public TsFileID() {
        this.regionId = -1;
        this.timePartitionId = -1L;
        this.fileVersion = -1L;
        this.compactionVersion = -1L;
    }

    public TsFileID(int regionId, long timePartitionId, long fileVersion, long compactionVersion) {
        this.regionId = regionId;
        this.timePartitionId = timePartitionId;
        this.fileVersion = fileVersion;
        this.compactionVersion = compactionVersion;
    }

    public TsFileID(String tsFileAbsolutePath) {
        int tmpRegionId = -1;
        long tmpTimePartitionId = -1L;
        String[] pathSegments = FilePathUtils.splitTsFilePath((String)tsFileAbsolutePath);
        int pathLength = pathSegments.length;
        if (pathLength >= 3) {
            try {
                tmpRegionId = Integer.parseInt(pathSegments[pathLength - 3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                tmpTimePartitionId = Long.parseLong(pathSegments[pathLength - 2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.regionId = tmpRegionId;
        this.timePartitionId = tmpTimePartitionId;
        long[] arr = null;
        try {
            arr = TsFileID.splitAndGetVersionArray(pathSegments[pathLength - 1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.fileVersion = arr == null || arr.length != 2 ? -1L : arr[0];
        this.compactionVersion = arr == null || arr.length != 2 ? -1L : arr[1];
    }

    private static long[] splitAndGetVersionArray(String tsFileName) {
        String[] names = tsFileName.split("-");
        long[] versionArray = new long[2];
        if (names.length != 4) {
            return versionArray;
        }
        versionArray[0] = Long.parseLong(names[1]);
        int dotIndex = names[3].indexOf(".");
        versionArray[1] = Long.parseLong(names[2]) << 32 | Long.parseLong(names[3].substring(0, dotIndex));
        return versionArray;
    }
}

