/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushStatus;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryValue;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public interface IMemTable
extends WALEntryValue {
    public Map<IDeviceID, IWritableMemChunkGroup> getMemTableMap();

    public void write(IDeviceID var1, List<IMeasurementSchema> var2, long var3, Object[] var5);

    public void writeAlignedRow(IDeviceID var1, List<IMeasurementSchema> var2, long var3, Object[] var5);

    public long size();

    public long memSize();

    public void addTVListRamCost(long var1);

    public void releaseTVListRamCost(long var1);

    public long getTVListsRamCost();

    public boolean reachTotalPointNumThreshold();

    public int getSeriesNumber();

    public long getTotalPointsNum();

    public void insert(InsertRowNode var1);

    public void insertAlignedRow(InsertRowNode var1);

    public void insertTablet(InsertTabletNode var1, int var2, int var3) throws WriteProcessException;

    public void insertAlignedTablet(InsertTabletNode var1, int var2, int var3) throws WriteProcessException;

    public ReadOnlyMemChunk query(QueryContext var1, PartialPath var2, long var3, List<Pair<Modification, IMemTable>> var5) throws IOException, QueryProcessException, MetadataException;

    public void clear();

    public boolean isEmpty();

    public void delete(PartialPath var1, PartialPath var2, long var3, long var5);

    public IMemTable copy();

    public boolean isSignalMemTable();

    public void setShouldFlush();

    public boolean shouldFlush();

    public void release();

    public boolean checkIfChunkDoesNotExist(IDeviceID var1, String var2);

    public long getCurrentTVListSize(IDeviceID var1, String var2);

    public void addTextDataSize(long var1);

    public void releaseTextDataSize(long var1);

    public long getMaxPlanIndex();

    public long getMinPlanIndex();

    public long getMemTableId();

    public long getCreatedTime();

    public long getUpdateTime();

    public FlushStatus getFlushStatus();

    public void setFlushStatus(FlushStatus var1);

    public Map<IDeviceID, Long> getMaxTime();

    public String getDatabase();

    public String getDataRegionId();

    public void setDatabaseAndDataRegionId(String var1, String var2);

    public void markAsNotGeneratedByPipe();

    public boolean isTotallyGeneratedByPipe();
}

