/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.ICompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.ICrossSpaceSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractCrossSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossSpaceCompactionCandidate;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.DeviceInfo;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.InsertionCrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.TsFileResourceCandidate;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.tsfile.exception.StopReadTsFileByInterruptException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteCrossSpaceCompactionSelector
implements ICrossSpaceSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected String logicalStorageGroupName;
    protected String dataRegionId;
    protected long timePartition;
    protected TsFileManager tsFileManager;
    private static boolean hasPrintedLog = false;
    private final long memoryBudget;
    private final int maxCrossCompactionFileNum;
    private final long maxCrossCompactionFileSize;
    private final AbstractCrossSpaceEstimator compactionEstimator;

    public RewriteCrossSpaceCompactionSelector(String logicalStorageGroupName, String dataRegionId, long timePartition, TsFileManager tsFileManager) {
        this.logicalStorageGroupName = logicalStorageGroupName;
        this.dataRegionId = dataRegionId;
        this.timePartition = timePartition;
        this.tsFileManager = tsFileManager;
        this.memoryBudget = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * config.getUsableCompactionMemoryProportion());
        this.maxCrossCompactionFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerCrossTask();
        this.maxCrossCompactionFileSize = IoTDBDescriptor.getInstance().getConfig().getMaxCrossCompactionCandidateFileSize();
        this.compactionEstimator = (AbstractCrossSpaceEstimator)ICompactionSelector.getCompactionEstimator(IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer(), false);
    }

    public CrossCompactionTaskResource selectOneTaskResources(CrossSpaceCompactionCandidate candidate) throws MergeException {
        if (candidate.getSeqFiles().isEmpty() || candidate.getUnseqFiles().isEmpty()) {
            return new CrossCompactionTaskResource();
        }
        try {
            LOGGER.debug("Selecting cross compaction task resources from {} seqFile, {} unseqFiles", (Object)candidate.getSeqFiles().size(), (Object)candidate.getUnseqFiles().size());
            CrossCompactionTaskResource crossCompactionTaskResource = this.executeTaskResourceSelection(candidate);
            return crossCompactionTaskResource;
        }
        catch (Exception e) {
            if (e instanceof StopReadTsFileByInterruptException || Thread.interrupted()) {
                Thread.currentThread().interrupt();
                CrossCompactionTaskResource crossCompactionTaskResource = new CrossCompactionTaskResource();
                return crossCompactionTaskResource;
            }
            throw new MergeException(e);
        }
        finally {
            this.compactionEstimator.cleanup();
        }
    }

    public InsertionCrossCompactionTaskResource selectOneInsertionTask(CrossSpaceCompactionCandidate candidate) throws MergeException {
        if (candidate.getUnseqFileCandidates().isEmpty()) {
            return new InsertionCrossCompactionTaskResource();
        }
        InsertionCrossSpaceCompactionSelector insertionCrossSpaceCompactionSelector = new InsertionCrossSpaceCompactionSelector(candidate);
        try {
            LOGGER.debug("Selecting insertion cross compaction task resources from {} seqFile, {} unseqFiles", (Object)candidate.getSeqFiles().size(), (Object)candidate.getUnseqFiles().size());
            InsertionCrossCompactionTaskResource result = insertionCrossSpaceCompactionSelector.executeInsertionCrossSpaceCompactionTaskSelection();
            if (result.isValid()) {
                return result;
            }
        }
        catch (IOException e) {
            throw new MergeException(e);
        }
        return new InsertionCrossCompactionTaskResource();
    }

    private boolean isAllFileCandidateValid(List<TsFileResourceCandidate> tsFileResourceCandidates) {
        for (TsFileResourceCandidate candidate : tsFileResourceCandidates) {
            if (candidate.isValidCandidate) continue;
            return false;
        }
        return true;
    }

    private CrossCompactionTaskResource executeTaskResourceSelection(CrossSpaceCompactionCandidate candidate) throws IOException {
        CrossCompactionTaskResource taskResource = new CrossCompactionTaskResource();
        while (candidate.hasNextSplit()) {
            CrossSpaceCompactionCandidate.CrossCompactionTaskResourceSplit split = candidate.nextSplit();
            TsFileResource unseqFile = split.unseqFile.resource;
            List<TsFileResource> targetSeqFiles = split.seqFiles.stream().map(c -> c.resource).collect(Collectors.toList());
            if (!split.atLeastOneSeqFileSelected) {
                LOGGER.debug("Unseq file {} does not overlap with any seq files.", (Object)unseqFile);
                TsFileResourceCandidate latestSealedSeqFile = this.getLatestSealedSeqFile(candidate.getSeqFileCandidates());
                if (latestSealedSeqFile == null) break;
                if (!latestSealedSeqFile.selected) {
                    targetSeqFiles.add(latestSealedSeqFile.resource);
                    latestSealedSeqFile.markAsSelected();
                }
            }
            ArrayList<TsFileResource> newSelectedSeqResources = new ArrayList<TsFileResource>(taskResource.getSeqFiles());
            newSelectedSeqResources.addAll(targetSeqFiles);
            ArrayList<TsFileResource> newSelectedUnseqResources = new ArrayList<TsFileResource>(taskResource.getUnseqFiles());
            newSelectedUnseqResources.add(unseqFile);
            long memoryCost = this.compactionEstimator.estimateCrossCompactionMemory(newSelectedSeqResources, newSelectedUnseqResources);
            if (!this.canAddToTaskResource(taskResource, unseqFile, targetSeqFiles, memoryCost)) break;
            taskResource.putResources(unseqFile, targetSeqFiles, memoryCost);
            LOGGER.debug("Adding a new unseqFile {} and seqFiles {} as candidates, new cost {}, total cost {}", new Object[]{unseqFile, targetSeqFiles, memoryCost, taskResource.getTotalMemoryCost()});
        }
        taskResource.sortSeqFiles(candidate.getSeqFiles());
        return taskResource;
    }

    private TsFileResourceCandidate getLatestSealedSeqFile(List<TsFileResourceCandidate> seqResourceCandidateList) {
        for (int i = seqResourceCandidateList.size() - 1; i >= 0; --i) {
            TsFileResourceCandidate seqResourceCandidate = seqResourceCandidateList.get(i);
            if (!seqResourceCandidate.resource.isClosed()) continue;
            if (!seqResourceCandidate.isValidCandidate) break;
            LOGGER.debug("Select one valid seq file {} for nonOverlap unseq file to compact with.", (Object)seqResourceCandidate.resource);
            return seqResourceCandidate;
        }
        return null;
    }

    private boolean canAddToTaskResource(CrossCompactionTaskResource taskResource, TsFileResource unseqFile, List<TsFileResource> seqFiles, long memoryCost) throws IOException {
        if (memoryCost == -1L) {
            return false;
        }
        TsFileNameGenerator.TsFileName unseqFileName = TsFileNameGenerator.getTsFileName(unseqFile.getTsFile().getName());
        long targetCompactionFileSize = config.getTargetCompactionFileSize();
        if (unseqFile.getTsFileSize() < targetCompactionFileSize && unseqFileName.getInnerCompactionCnt() < config.getMinCrossCompactionUnseqFileLevel()) {
            return false;
        }
        long totalFileSize = unseqFile.getTsFileSize();
        for (TsFileResource f : seqFiles) {
            if ((double)f.getTsFileSize() >= (double)targetCompactionFileSize * 1.5) {
                return false;
            }
            totalFileSize += f.getTsFileSize();
        }
        if (taskResource.getUnseqFiles().isEmpty()) {
            return true;
        }
        return taskResource.getTotalFileNums() + 1L + (long)seqFiles.size() <= (long)this.maxCrossCompactionFileNum && taskResource.getTotalFileSize() + totalFileSize <= this.maxCrossCompactionFileSize && memoryCost < this.memoryBudget;
    }

    private boolean canSubmitCrossTask(List<TsFileResource> sequenceFileList, List<TsFileResource> unsequenceFileList) {
        return !sequenceFileList.isEmpty() && !unsequenceFileList.isEmpty();
    }

    @Override
    public List<CrossCompactionTaskResource> selectCrossSpaceTask(List<TsFileResource> sequenceFileList, List<TsFileResource> unsequenceFilelist) {
        return this.selectCrossSpaceTask(sequenceFileList, unsequenceFilelist, false);
    }

    public List<CrossCompactionTaskResource> selectInsertionCrossSpaceTask(List<TsFileResource> sequenceFileList, List<TsFileResource> unsequenceFileList) {
        return this.selectCrossSpaceTask(sequenceFileList, unsequenceFileList, true);
    }

    public List<CrossCompactionTaskResource> selectCrossSpaceTask(List<TsFileResource> sequenceFileList, List<TsFileResource> unsequenceFileList, boolean isInsertionTask) {
        long startTime = System.currentTimeMillis();
        long ttlLowerBound = System.currentTimeMillis() - Long.MAX_VALUE;
        CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(sequenceFileList, unsequenceFileList, ttlLowerBound);
        try {
            CrossCompactionTaskResource taskResources = isInsertionTask ? this.selectOneInsertionTask(candidate) : this.selectOneTaskResources(candidate);
            String sgDataRegionId = this.logicalStorageGroupName + "-" + this.dataRegionId;
            if (!taskResources.isValid()) {
                if (!hasPrintedLog) {
                    LOGGER.info("{} [{}] Total source files: {} seqFiles, {} unseqFiles. Candidate source files: {} seqFiles, {} unseqFiles. Cannot select any files because they do not meet the conditions or may be occupied by other compaction threads.", new Object[]{isInsertionTask ? "InsertionCrossSpaceCompaction" : "CrossSpaceCompaction", sgDataRegionId, sequenceFileList.size(), unsequenceFileList.size(), candidate.getSeqFiles().size(), candidate.getUnseqFiles().size()});
                    hasPrintedLog = true;
                }
                return Collections.emptyList();
            }
            long timeCost = System.currentTimeMillis() - startTime;
            LOGGER.info("{} [{}] Total source files: {} seqFiles, {} unseqFiles. Candidate source files: {} seqFiles, {} unseqFiles. Selected source files: {} seqFiles, {} unseqFiles, estimated memory cost {} MB, total selected file size is {} MB, total selected seq file size is {} MB, total selected unseq file size is {} MB, time consumption {}ms.", new Object[]{sgDataRegionId, isInsertionTask ? "InsertionCrossSpaceCompaction" : "CrossSpaceCompaction", sequenceFileList.size(), unsequenceFileList.size(), candidate.getSeqFiles().size(), candidate.getUnseqFiles().size(), taskResources.getSeqFiles().size(), taskResources.getUnseqFiles().size(), Float.valueOf((float)taskResources.getTotalMemoryCost() / 1024.0f / 1024.0f), Float.valueOf((float)taskResources.getTotalFileSize() / 1024.0f / 1024.0f), Float.valueOf(taskResources.getTotalSeqFileSize() / 1024.0f / 1024.0f), Float.valueOf(taskResources.getTotalUnseqFileSize() / 1024.0f / 1024.0f), timeCost});
            CompactionMetrics.getInstance().updateCompactionTaskSelectionTimeCost(isInsertionTask ? CompactionTaskType.INSERTION : CompactionTaskType.CROSS, timeCost);
            hasPrintedLog = false;
            return Collections.singletonList(taskResources);
        }
        catch (MergeException e) {
            if (!this.tsFileManager.isAllowCompaction()) {
                return Collections.emptyList();
            }
            LOGGER.error("{} cannot select file for cross space compaction", (Object)this.logicalStorageGroupName, (Object)e);
            return Collections.emptyList();
        }
    }

    public static class InsertionCrossSpaceCompactionSelector {
        private List<TsFileResourceCandidate> seqFiles;
        private List<TsFileResourceCandidate> unseqFiles;

        public InsertionCrossSpaceCompactionSelector(CrossSpaceCompactionCandidate candidate) {
            this.seqFiles = candidate.getSeqFileCandidates();
            this.unseqFiles = candidate.getUnseqFileCandidates();
        }

        private InsertionCrossCompactionTaskResource executeInsertionCrossSpaceCompactionTaskSelection() throws IOException {
            InsertionCrossCompactionTaskResource result = new InsertionCrossCompactionTaskResource();
            if (this.unseqFiles.isEmpty()) {
                return result;
            }
            if (this.seqFiles.isEmpty()) {
                result.toInsertUnSeqFile = this.unseqFiles.get((int)0).resource;
                result.targetFileTimestamp = Math.min(System.currentTimeMillis(), this.getTimestampInFileName(this.unseqFiles.get(0)));
            } else {
                for (TsFileResourceCandidate unseqFile : this.unseqFiles) {
                    if (!unseqFile.resource.isInsertionCompactionTaskCandidate() || !(result = this.selectCurrentUnSeqFile(unseqFile)).isValid()) continue;
                    break;
                }
            }
            TsFileResourceCandidate firstUnseqFile = this.unseqFiles.get(0);
            result.firstUnSeqFileInParitition = firstUnseqFile.resource;
            return result;
        }

        private InsertionCrossCompactionTaskResource selectCurrentUnSeqFile(TsFileResourceCandidate unseqFile) throws IOException {
            int previousSeqFileIndex = 0;
            int nextSeqFileIndex = this.seqFiles.size();
            InsertionCrossCompactionTaskResource result = new InsertionCrossCompactionTaskResource();
            boolean hasPreviousSeqFile = false;
            block0: for (DeviceInfo unseqDeviceInfo : unseqFile.getDevices()) {
                IDeviceID deviceId = unseqDeviceInfo.deviceId;
                long startTimeOfUnSeqDevice = unseqDeviceInfo.startTime;
                long endTimeOfUnSeqDevice = unseqDeviceInfo.endTime;
                for (int i = 0; i < this.seqFiles.size(); ++i) {
                    TsFileResourceCandidate seqFile = this.seqFiles.get(i);
                    if (seqFile.unsealed()) {
                        nextSeqFileIndex = Math.min(nextSeqFileIndex, i);
                    }
                    if (!seqFile.containsDevice(deviceId)) continue;
                    DeviceInfo seqDeviceInfo = seqFile.getDeviceInfoById(deviceId);
                    long startTimeOfSeqDevice = seqDeviceInfo.startTime;
                    long endTimeOfSeqDevice = seqDeviceInfo.endTime;
                    if (startTimeOfUnSeqDevice <= endTimeOfSeqDevice && endTimeOfUnSeqDevice >= startTimeOfSeqDevice) {
                        unseqFile.resource.setInsertionCompactionTaskCandidate(false);
                        return result;
                    }
                    if (startTimeOfUnSeqDevice > endTimeOfSeqDevice) {
                        previousSeqFileIndex = Math.max(previousSeqFileIndex, i);
                        hasPreviousSeqFile = true;
                        continue;
                    }
                    nextSeqFileIndex = Math.min(nextSeqFileIndex, i);
                    continue block0;
                }
            }
            if (hasPreviousSeqFile) {
                boolean insertLastInSeqSpace;
                boolean bl = insertLastInSeqSpace = nextSeqFileIndex == this.seqFiles.size() && previousSeqFileIndex == this.seqFiles.size() - 1;
                if (insertLastInSeqSpace) {
                    TsFileResourceCandidate prev = this.seqFiles.get(previousSeqFileIndex);
                    long prevTimestamp = this.getTimestampInFileName(prev);
                    if (prev.isValidCandidate) {
                        result.prevSeqFile = prev.resource;
                        result.targetFileTimestamp = prevTimestamp + 1L;
                        result.toInsertUnSeqFile = unseqFile.resource;
                    }
                    return result;
                }
                for (int i = previousSeqFileIndex; i < Math.min(nextSeqFileIndex, this.seqFiles.size() - 1); ++i) {
                    TsFileResourceCandidate prev = this.seqFiles.get(i);
                    TsFileResourceCandidate next = this.seqFiles.get(i + 1);
                    if (!prev.isValidCandidate || !next.isValidCandidate) continue;
                    long prevTimestamp = this.getTimestampInFileName(prev);
                    long nextTimestamp = this.getTimestampInFileName(next);
                    if (nextTimestamp - prevTimestamp <= 1L) continue;
                    result.prevSeqFile = prev.resource;
                    result.nextSeqFile = next.resource;
                    result.targetFileTimestamp = prevTimestamp + Math.max(1L, (nextTimestamp - prevTimestamp) / 2L);
                    result.toInsertUnSeqFile = unseqFile.resource;
                    break;
                }
            } else {
                TsFileResourceCandidate next = this.seqFiles.get(0);
                long nextTimestamp = this.getTimestampInFileName(next);
                if (nextTimestamp < 1L) {
                    return result;
                }
                result.nextSeqFile = next.resource;
                result.targetFileTimestamp = nextTimestamp / 2L;
                result.toInsertUnSeqFile = unseqFile.resource;
            }
            return result;
        }

        private long getTimestampInFileName(TsFileResourceCandidate tsFileResourceCandidate) throws IOException {
            return TsFileNameGenerator.getTsFileName(tsFileResourceCandidate.resource.getTsFile().getName()).getTime();
        }
    }
}

