/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.PageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader.CompactionAlignedChunkReader;
import org.apache.iotdb.tsfile.file.header.PageHeader;

public class AlignedPageElement
extends PageElement {
    private final PageHeader timePageHeader;
    private final List<PageHeader> valuePageHeaders;
    private ByteBuffer timePageData;
    private List<ByteBuffer> valuePageDataList;
    private final CompactionAlignedChunkReader chunkReader;

    public AlignedPageElement(PageHeader timePageHeader, List<PageHeader> valuePageHeaders, ByteBuffer timePageData, List<ByteBuffer> valuePageDataList, CompactionAlignedChunkReader alignedChunkReader, ChunkMetadataElement chunkMetadataElement, boolean isLastPage, long priority) {
        super(chunkMetadataElement, isLastPage, priority);
        this.timePageHeader = timePageHeader;
        this.valuePageHeaders = valuePageHeaders;
        this.timePageData = timePageData;
        this.valuePageDataList = valuePageDataList;
        this.chunkReader = alignedChunkReader;
    }

    @Override
    public void deserializePage() throws IOException {
        this.pointReader = this.chunkReader.getPagePointReader(this.timePageHeader, this.valuePageHeaders, this.timePageData, this.valuePageDataList);
        this.timePageData = null;
        this.valuePageDataList = null;
    }

    @Override
    public long getStartTime() {
        return this.timePageHeader.getStartTime();
    }

    @Override
    public long getEndTime() {
        return this.timePageHeader.getEndTime();
    }

    public PageHeader getTimePageHeader() {
        return this.timePageHeader;
    }

    public List<PageHeader> getValuePageHeaders() {
        return this.valuePageHeaders;
    }

    public ByteBuffer getTimePageData() {
        return this.timePageData;
    }

    public List<ByteBuffer> getValuePageDataList() {
        return this.valuePageDataList;
    }
}

