/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.statistics.StatisticLine;
import org.apache.iotdb.mpp.rpc.thrift.TFetchFragmentInstanceStatisticsResp;
import org.apache.iotdb.mpp.rpc.thrift.TOperatorStatistics;
import org.apache.iotdb.mpp.rpc.thrift.TQueryStatistics;

public class FragmentInstanceStatisticsDrawer {
    private int maxLineLength = 0;
    private static final double EPSILON = 1.0E-10;
    private final List<StatisticLine> planHeader = new ArrayList<StatisticLine>();
    private static final double NS_TO_MS_FACTOR = 1.0E-6;

    public void renderPlanStatistics(MPPQueryContext context) {
        this.addLine(this.planHeader, 0, String.format("Analyze Cost: %.3f ms", (double)context.getAnalyzeCost() * 1.0E-6));
        this.addLine(this.planHeader, 0, String.format("Fetch Partition Cost: %.3f ms", (double)context.getFetchPartitionCost() * 1.0E-6));
        this.addLine(this.planHeader, 0, String.format("Fetch Schema Cost: %.3f ms", (double)context.getFetchSchemaCost() * 1.0E-6));
        this.addLine(this.planHeader, 0, String.format("Logical Plan Cost: %.3f ms", (double)context.getLogicalPlanCost() * 1.0E-6));
        this.addLine(this.planHeader, 0, String.format("Logical Optimization Cost: %.3f ms", (double)context.getLogicalOptimizationCost() * 1.0E-6));
        this.addLine(this.planHeader, 0, String.format("Distribution Plan Cost: %.3f ms", (double)context.getDistributionPlanCost() * 1.0E-6));
    }

    public List<StatisticLine> renderFragmentInstances(List<FragmentInstance> instancesToBeRendered, Map<FragmentInstanceId, TFetchFragmentInstanceStatisticsResp> allStatistics, boolean verbose) {
        ArrayList<StatisticLine> table = new ArrayList<StatisticLine>(this.planHeader);
        this.addLine(table, 0, String.format("Fragment Instances Count: %s", instancesToBeRendered.size() - 1));
        for (FragmentInstance instance : instancesToBeRendered) {
            ArrayList<StatisticLine> singleFragmentInstanceArea = new ArrayList<StatisticLine>();
            TFetchFragmentInstanceStatisticsResp statistics = allStatistics.get(instance.getId());
            if (statistics == null || statistics.getDataRegion() == null) continue;
            this.addBlankLine(singleFragmentInstanceArea);
            this.addLine(singleFragmentInstanceArea, 0, String.format("FRAGMENT-INSTANCE[Id: %s][IP: %s][DataRegion: %s][State: %s]", instance.getId().toString(), statistics.getIp(), statistics.getDataRegion(), statistics.getState()));
            this.addLine(singleFragmentInstanceArea, 1, String.format("Total Wall Time: %s ms", statistics.getEndTimeInMS() - statistics.getStartTimeInMS()));
            this.addLine(singleFragmentInstanceArea, 1, String.format("Cost of initDataQuerySource: %.3f ms", (double)statistics.getInitDataQuerySourceCost() * 1.0E-6));
            this.addLine(singleFragmentInstanceArea, 1, String.format("Seq File(unclosed): %s, Seq File(closed): %s", statistics.getSeqUnclosedNum(), statistics.getSeqClosednNum()));
            this.addLine(singleFragmentInstanceArea, 1, String.format("UnSeq File(unclosed): %s, UnSeq File(closed): %s", statistics.getUnseqUnclosedNum(), statistics.getUnseqClosedNum()));
            this.addLine(singleFragmentInstanceArea, 1, String.format("ready queued time: %.3f ms, blocked queued time: %.3f ms", (double)statistics.getReadyQueuedTime() * 1.0E-6, (double)statistics.getBlockQueuedTime() * 1.0E-6));
            if (verbose) {
                this.renderQueryStatistics(statistics.getQueryStatistics(), singleFragmentInstanceArea);
            }
            PlanNode planNodeTree = instance.getFragment().getPlanNodeTree();
            this.renderOperator(planNodeTree, statistics.getOperatorStatisticsMap(), singleFragmentInstanceArea, 2);
            table.addAll(singleFragmentInstanceArea);
        }
        return table;
    }

    private void addLineWithValueCheck(List<StatisticLine> singleFragmentInstanceArea, int level, String valueName, long value) {
        if (value != 0L) {
            this.addLine(singleFragmentInstanceArea, level, valueName + String.format(": %s", value));
        }
    }

    private void addLineWithValueCheck(List<StatisticLine> singleFragmentInstanceArea, int level, String valueName, double value) {
        if (Math.abs(value) > 1.0E-10) {
            this.addLine(singleFragmentInstanceArea, level, valueName + String.format(": %.3f", value));
        }
    }

    private void addBlankLine(List<StatisticLine> singleFragmentInstanceArea) {
        this.addLine(singleFragmentInstanceArea, 0, " ");
    }

    private void renderQueryStatistics(TQueryStatistics queryStatistics, List<StatisticLine> singleFragmentInstanceArea) {
        this.addLine(singleFragmentInstanceArea, 1, "Query Statistics:");
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataDiskSeqCount", queryStatistics.loadTimeSeriesMetadataDiskSeqCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataDiskUnSeqCount", queryStatistics.loadTimeSeriesMetadataDiskUnSeqCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataMemSeqCount", queryStatistics.loadTimeSeriesMetadataMemSeqCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataMemUnSeqCount", queryStatistics.loadTimeSeriesMetadataMemUnSeqCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataAlignedDiskSeqCount", queryStatistics.loadTimeSeriesMetadataAlignedDiskSeqCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataAlignedDiskUnSeqCount", queryStatistics.loadTimeSeriesMetadataAlignedDiskUnSeqCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataAlignedMemSeqCount", queryStatistics.loadTimeSeriesMetadataAlignedMemSeqCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataAlignedMemUnSeqCount", queryStatistics.loadTimeSeriesMetadataAlignedMemUnSeqCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataDiskSeqTime", (double)queryStatistics.loadTimeSeriesMetadataDiskSeqTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataDiskUnSeqTime", (double)queryStatistics.loadTimeSeriesMetadataDiskUnSeqTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataMemSeqTime", (double)queryStatistics.loadTimeSeriesMetadataMemSeqTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataMemUnSeqTime", (double)queryStatistics.loadTimeSeriesMetadataMemUnSeqTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataAlignedDiskSeqTime", (double)queryStatistics.loadTimeSeriesMetadataAlignedDiskSeqTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataAlignedDiskUnSeqTime", (double)queryStatistics.loadTimeSeriesMetadataAlignedDiskUnSeqTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataAlignedMemSeqTime", (double)queryStatistics.loadTimeSeriesMetadataAlignedMemSeqTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "loadTimeSeriesMetadataAlignedMemUnSeqTime", (double)queryStatistics.loadTimeSeriesMetadataAlignedMemUnSeqTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "constructNonAlignedChunkReadersDiskCount", queryStatistics.constructNonAlignedChunkReadersDiskCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "constructNonAlignedChunkReadersMemCount", queryStatistics.constructNonAlignedChunkReadersMemCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "constructAlignedChunkReadersDiskCount", queryStatistics.constructAlignedChunkReadersDiskCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "constructAlignedChunkReadersMemCount", queryStatistics.constructAlignedChunkReadersMemCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "constructNonAlignedChunkReadersDiskTime", (double)queryStatistics.constructNonAlignedChunkReadersDiskTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "constructNonAlignedChunkReadersMemTime", (double)queryStatistics.constructNonAlignedChunkReadersMemTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "constructAlignedChunkReadersDiskTime", (double)queryStatistics.constructAlignedChunkReadersDiskTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "constructAlignedChunkReadersMemTime", (double)queryStatistics.constructAlignedChunkReadersMemTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "pageReadersDecodeAlignedDiskCount", queryStatistics.pageReadersDecodeAlignedDiskCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "pageReadersDecodeAlignedDiskTime", (double)queryStatistics.pageReadersDecodeAlignedDiskTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "pageReadersDecodeAlignedMemCount", queryStatistics.pageReadersDecodeAlignedMemCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "pageReadersDecodeAlignedMemTime", (double)queryStatistics.pageReadersDecodeAlignedMemTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "pageReadersDecodeNonAlignedDiskCount", queryStatistics.pageReadersDecodeNonAlignedDiskCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "pageReadersDecodeNonAlignedDiskTime", (double)queryStatistics.pageReadersDecodeNonAlignedDiskTime * 1.0E-6);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "pageReadersDecodeNonAlignedMemCount", queryStatistics.pageReadersDecodeNonAlignedMemCount);
        this.addLineWithValueCheck(singleFragmentInstanceArea, 2, "pageReadersDecodeNonAlignedMemTime", (double)queryStatistics.pageReadersDecodeNonAlignedMemTime * 1.0E-6);
    }

    private void addLine(List<StatisticLine> resultForSingleInstance, int level, String value) {
        this.maxLineLength = Math.max(this.maxLineLength, value.length());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        sb.append(value);
        this.maxLineLength = Math.max(this.maxLineLength, sb.length());
        resultForSingleInstance.add(new StatisticLine(sb.toString(), level));
    }

    private void renderOperator(PlanNode planNodeTree, Map<String, TOperatorStatistics> operatorStatistics, List<StatisticLine> singleFragmentInstanceArea, int indentNum) {
        if (planNodeTree == null) {
            return;
        }
        TOperatorStatistics operatorStatistic = operatorStatistics.get(planNodeTree.getPlanNodeId().toString());
        if (operatorStatistic != null) {
            this.addLine(singleFragmentInstanceArea, indentNum, String.format("[PlanNodeId %s]: %s(%s) %s", planNodeTree.getPlanNodeId().toString(), planNodeTree.getClass().getSimpleName(), operatorStatistic.getOperatorType(), operatorStatistic.isSetCount() ? "Count: * " + operatorStatistic.getCount() : ""));
            this.addLine(singleFragmentInstanceArea, indentNum + 2, String.format("CPU Time: %.3f ms", (double)operatorStatistic.getTotalExecutionTimeInNanos() * 1.0E-6));
            this.addLine(singleFragmentInstanceArea, indentNum + 2, String.format("output: %s rows", operatorStatistic.getOutputRows()));
            this.addLine(singleFragmentInstanceArea, indentNum + 2, String.format("HasNext() Called Count: %s", operatorStatistic.hasNextCalledCount));
            this.addLine(singleFragmentInstanceArea, indentNum + 2, String.format("Next() Called Count: %s", operatorStatistic.nextCalledCount));
            this.addLineWithValueCheck(singleFragmentInstanceArea, indentNum + 2, "Estimated Memory Size: ", operatorStatistic.getMemoryUsage());
            if (operatorStatistic.getSpecifiedInfoSize() != 0) {
                for (Map.Entry entry : operatorStatistic.getSpecifiedInfo().entrySet()) {
                    this.addLine(singleFragmentInstanceArea, indentNum + 2, String.format("%s: %s", entry.getKey(), entry.getValue()));
                }
            }
        }
        for (PlanNode planNode : planNodeTree.getChildren()) {
            this.renderOperator(planNode, operatorStatistics, singleFragmentInstanceArea, indentNum + 1);
        }
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }
}

