/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IRollbackPreDeactivateTemplatePlan;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class RollbackPreDeactivateTemplateNode
extends PlanNode
implements IRollbackPreDeactivateTemplatePlan {
    private Map<PartialPath, List<Integer>> templateSetInfo;

    public RollbackPreDeactivateTemplateNode(PlanNodeId id, Map<PartialPath, List<Integer>> templateSetInfo) {
        super(id);
        this.templateSetInfo = templateSetInfo;
    }

    @Override
    public List<PlanNode> getChildren() {
        return null;
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.ROLLBACK_PRE_DEACTIVATE_TEMPLATE_NODE;
    }

    @Override
    public PlanNode clone() {
        return new RollbackPreDeactivateTemplateNode(this.getPlanNodeId(), this.templateSetInfo);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitRollbackPreDeactivateTemplate(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.ROLLBACK_PRE_DEACTIVATE_TEMPLATE_NODE.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.templateSetInfo.size(), (ByteBuffer)byteBuffer);
        this.templateSetInfo.forEach((k, v) -> {
            k.serialize(byteBuffer);
            ReadWriteIOUtils.write((int)v.size(), (ByteBuffer)byteBuffer);
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                int templateId = (Integer)iterator.next();
                ReadWriteIOUtils.write((int)templateId, (ByteBuffer)byteBuffer);
            }
        });
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.ROLLBACK_PRE_DEACTIVATE_TEMPLATE_NODE.serialize(stream);
        ReadWriteIOUtils.write((int)this.templateSetInfo.size(), (OutputStream)stream);
        for (Map.Entry<PartialPath, List<Integer>> entry : this.templateSetInfo.entrySet()) {
            entry.getKey().serialize((OutputStream)stream);
            ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)stream);
            for (int templateId : entry.getValue()) {
                ReadWriteIOUtils.write((int)templateId, (OutputStream)stream);
            }
        }
    }

    public static RollbackPreDeactivateTemplateNode deserialize(ByteBuffer buffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        HashMap<PartialPath, List<Integer>> templateSetInfo = new HashMap<PartialPath, List<Integer>>(size);
        for (int i = 0; i < size; ++i) {
            PartialPath pattern = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)buffer);
            int templateNum = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            ArrayList<Integer> templateIdList = new ArrayList<Integer>(templateNum);
            for (int j = 0; j < templateNum; ++j) {
                templateIdList.add(ReadWriteIOUtils.readInt((ByteBuffer)buffer));
            }
            templateSetInfo.put(pattern, templateIdList);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new RollbackPreDeactivateTemplateNode(planNodeId, templateSetInfo);
    }

    @Override
    public Map<PartialPath, List<Integer>> getTemplateSetInfo() {
        return this.templateSetInfo;
    }

    @Override
    public void setTemplateSetInfo(Map<PartialPath, List<Integer>> templateSetInfo) {
        this.templateSetInfo = templateSetInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RollbackPreDeactivateTemplateNode that = (RollbackPreDeactivateTemplateNode)o;
        return Objects.equals(this.templateSetInfo, that.templateSetInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.templateSetInfo);
    }
}

